'\"
'\" Generated from file 'cmdr_officer\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr::officer" n 1\&.4\&.1 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr::officer \- Cmdr - (Internal) Aggregation of multiple commands for dispatch\&.
.SH SYNOPSIS
package require \fBcmdr::officer \fR
.sp
\fB::cmdr::officer\fR \fBnew\fR \fIsuper\fR \fIname\fR \fIactions\fR
.sp
\fB::cmdr::officer\fR \fBcreate\fR \fIobj\fR \fIsuper\fR \fIname\fR \fIactions\fR
.sp
\fB<officer>\fR \fBchildren\fR
.sp
\fB<officer>\fR \fBcomplete\fR \fIline\fR
.sp
\fB<officer>\fR \fBcomplete-words\fR \fIparse\fR
.sp
\fB<officer>\fR \fBcontinued\fR \fIline\fR
.sp
\fB<officer>\fR \fBdefault\fR
.sp
\fB<officer>\fR \fBdispatch\fR \fIcmd\fR
.sp
\fB<officer>\fR \fBdo\fR ?\fIword\fR\&.\&.\&.?
.sp
\fB<officer>\fR \fBintercept\fR \fIcmd\fR
.sp
\fB<officer>\fR \fBehandler\fR \fIcmd\fR
.sp
\fB<officer>\fR \fBcustom-setup\fR \fIcmd\fR
.sp
\fB<officer>\fR \fBexit\fR
.sp
\fB<officer>\fR \fBextend\fR \fIpath\fR \fIarguments\fR \fIaction\fR
.sp
\fB<officer>\fR \fBfind\fR \fIpath\fR
.sp
\fB<officer>\fR \fBhas\fR \fIname\fR
.sp
\fB<officer>\fR \fBhasdefault\fR
.sp
\fB<officer>\fR \fBhelp\fR ?\fIprefix\fR?
.sp
\fB<officer>\fR \fBknown\fR
.sp
\fB<officer>\fR \fBlearn\fR \fIscript\fR
.sp
\fB<officer>\fR \fBlookup\fR \fIname\fR
.sp
\fB<officer>\fR \fBprompt1\fR
.sp
\fB<officer>\fR \fBprompt2\fR
.sp
\fB<officer>\fR \fBreport\fR \fIwhat\fR \fIdata\fR
.sp
\fB<officer>\fR \fBshell-exit\fR \fIconfig\fR
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This package implements \fIofficers\fR, the inner nodes of command
hierarchies\&.  Each officer can execute many actions, by delegating
them to their sub-ordinate actors, officers and privates\&.
.PP
This class is sub-class of \fBcmdr::actor\fR\&.
.SH "CLASS API"
The class API is not public\&. It is used internally by the framework
when parsing a command hierarchy specification to create the necessary
officer instances\&.
.PP
It is described here for use by developers maintaining,
modifying and extending the framework itself\&. A user of the framework
has no need for it\&.
.TP
\fB::cmdr::officer\fR \fBnew\fR \fIsuper\fR \fIname\fR \fIactions\fR
Create an auto-named instance of \fBcmdr::officer\fR\&.
.sp
\fINot used\fR\&.
.TP
\fB::cmdr::officer\fR \fBcreate\fR \fIobj\fR \fIsuper\fR \fIname\fR \fIactions\fR
Create a new instance of \fBcmdr::officer\fR, named \fIobj\fR\&.
Used by the DSL processing parts of the framework to instantiate officers\&.
.RS
.TP
object \fIsuper\fR
The instance command of the actor (officer actually) which contains the new officer\&.
.TP
string \fIname\fR
The user-visible name of the command\&.
.TP
script \fIactions\fR
The specification of the officer's subordinates\&.
Please read \fICmdr - Officer Specification Language\fR for the details\&.
.RE
.PP
.SH "INSTANCE API"
The instance API is not public\&. It is used internally by the framework
during the parsing of a command hierarchy specification to configure
the officer instances, and when processing a command line at runtime
to manage navigation of the hierarchy, word-completion, etc\&.
.PP
It is described here for use by developers maintaining,
modifying and extending the framework itself\&. A user of the framework
has no need for it\&.
.TP
\fB<officer>\fR \fBchildren\fR
This method returns a list containing the instance commands of the
subordinate actors managed by this officer\&.
See also method \fBknown\fR which returns a list of names\&.
.TP
\fB<officer>\fR \fBcomplete\fR \fIline\fR
This hook-method for the main shell is responsible for computing the
set of completions for the entered \fIline\fR\&.
.RS
.TP
string \fIline\fR
The command line to complete\&.
.RE
.TP
\fB<officer>\fR \fBcomplete-words\fR \fIparse\fR
This method is part of the main shell command line
completion\&. For the details of its workings please read
\fICmdr - Internals of command line completion\fR\&.
.sp
Given the completion state \fIparse\fR of a partial
command line it returns a list of strings which are the valid
completions at this point\&.
.RS
.TP
dict \fIparse\fR
A dictionary holding the current completion state of a partial command
line\&.
.RE
.TP
\fB<officer>\fR \fBcontinued\fR \fIline\fR
This hook-method for the main shell is responsible for the detection
of a continuation-line in the entered command \fIline\fR\&. It always
returns the boolean value \fBfalse\fR as the main shell does not
support continuation lines\&.
.RS
.TP
list \fIlist\fR
.RE
.TP
\fB<officer>\fR \fBdefault\fR
This method returns the instance command of the subordinate to use
during command line processing if the first word does not specify a
known subordinate\&. An error is thrown if no such default was specified
for this officer\&. See also method \fBhasdefault\fR\&.
.TP
\fB<officer>\fR \fBdispatch\fR \fIcmd\fR
This hook-method for the main shell is responsible for the recognition
and execution of the supported commands\&.
.RS
.TP
string \fIcmd\fR
The command line containing the command to run\&.
.RE
.TP
\fB<officer>\fR \fBdo\fR ?\fIword\fR\&.\&.\&.?
This method parses the \fIword\fRs of the command line, matching them
to the sub-ordinates of the officer\&. When done without error it
recursively invokes the chosen sub-ordinate to continue processing\&.
.sp
This represents the "Dispatch" phase of command line processing\&.
.RS
.TP
string \fIword\fR
The words of the command line to parse and match to parameters\&.
.RE
.TP
\fB<officer>\fR \fBintercept\fR \fIcmd\fR
.TP
\fB<officer>\fR \fBehandler\fR \fIcmd\fR
\fINote:\fR While the form \fBehandler\fR is still usable, it is
deprecated and will be removed in a future release\&.
This method specifies a command prefix to wrap around the parsing of
the command line for the officer, and the execution of its action\&.
.RS
.TP
cmd-prefix \fIcmd\fR
A command prefix taking a single argument, a script\&. The command
prefix has to execute this script in its caller's context\&. The script
will parse words for the officer,m and perform its action\&. The command
prefix then has the responsbility to perform any custom cleanup action
required by the application using the framework to prevent leakage of
data between multiple commands executed one after the other (i\&.e\&. in
an interactive shell run by the framework)\&.
.RE
.TP
\fB<officer>\fR \fBcustom-setup\fR \fIcmd\fR
This method specifies a command prefix which will be run all the
regular setup of the officer from its specification is done, to
perform customizations\&.
.sp
An example of this can be seen in the package
\fBcmdr::history\fR\&. It provides a command
\fBcmdr::history::attach\fR to add the history management commands to
the actor in question, suitable as argument to this method\&.
.sp
When called multiple times, the specified commands
accumulate\&. This makes it easy to specify several indepedent
customizations\&.
.RS
.TP
cmd-prefix \fIcmd\fR
A command prefix taking a single argument, the instance command of an
\fBcmd::actor\fR\&. The command prefix has full access to this actor
and can modify it as it sees fit\&. The common use case will be the
extension of the actor with additional subordinates\&.
.RE
.TP
\fB<officer>\fR \fBexit\fR
This hook-method for the main shell returns a boolean value indicating
whether the main shell was stopped and has to exit (\fBtrue\fR), or
not (\fBfalse\fR)\&.
.TP
\fB<officer>\fR \fBextend\fR \fIpath\fR \fIarguments\fR \fIaction\fR
A convenience method to create a "private" command underneath this
officer, with the command name \fIpath\fR (a list of names)\&. Any
intermediate officers are created as needed\&. An error is thrown if any
of the intermediates already exist as a (non-extensible) private, or
if the last command already exists\&.
.sp
The arguments after the \fIpath\fR match the constructor of
privates in number and semantics\&.
.RS
.TP
script \fIpath\fR
The list of names specifying the route from this officer to the new
private\&. The last element is the name of the private command, while
the preceding names specify the intermediate officers\&.
.TP
script \fIarguments\fR
The specification of the private's parameters\&.
Please read \fICmdr - Parameter Specification Language\fR for the details\&.
.TP
cmd-prefix \fIaction\fR
The command prefix to invoke when this private is selected for
execution\&.  It takes a single argument, the instance command of the
hidden \fBcmdr::config\fR container holding the private's
parameters\&. The result of the action, if there is any, is ignored by
the framework\&.
.RE
.TP
\fB<officer>\fR \fBfind\fR \fIpath\fR
This method returns the instance command of the sub-ordinate with the
given \fIpath\fR (a list) of names\&. An error is thrown if such a sub-ordinate
does not exist\&. This is an extension of \fBlookup\fR to paths of names\&.
.sp
An empty \fIpath\fR is allowed and refers to the officer itself\&.
.RS
.TP
string \fIpath\fR
The path of names to the sub-ordinate to look for\&.
.RE
.TP
\fB<officer>\fR \fBhas\fR \fIname\fR
This method returns a boolean value indicating if this officer has a
sub-ordinate of the given \fIname\fR (\fBtrue\fR), or not
(\fBfalse\fR)\&. See also method \fBlookup\fR\&.
.RS
.TP
string \fIname\fR
The name of the sub-ordinate to look for\&.
.RE
.TP
\fB<officer>\fR \fBhasdefault\fR
This method returns a boolean value indicating if this officer has a
default sub-ordinate (\fBtrue\fR), or not (\fBfalse\fR)\&. See also
method \fBdefault\fR\&.
.TP
\fB<officer>\fR \fBhelp\fR ?\fIprefix\fR?
This method returns the help information for the officer and its
subordinates\&. The \fIprefix\fR, if specified provides the name of the
officer within the help data\&. It defaults to the empty string\&.
The result of the command is a structure of the form
described in section \fBHelp Information\fR\&.
.RS
.TP
string \fIprefix\fR
The name to use for the officer within the generated help\&.
.RE
.TP
\fB<officer>\fR \fBknown\fR
This method returns a list containing the names of the subordinate
actors managed by this officer\&.
See also method \fBchildren\fR which returns a list of instance
commands\&.
See also method \fBlookup\fR to map names to instance commands\&.
.TP
\fB<officer>\fR \fBlearn\fR \fIscript\fR
This method takes a regular specification script and uses it to extend
the set of subordinates known to this officer\&. This is the same type
of script as used during construction, except here we dynamically
extend the officer\&.
.RS
.TP
script \fIactions\fR
The specification of the officer's additional subordinates\&.
Please read \fICmdr - Officer Specification Language\fR for the details\&.
.RE
.TP
\fB<officer>\fR \fBlookup\fR \fIname\fR
This method returns the instance command of the sub-ordinate with the
given \fIname\fR\&. An error is thrown if such a sub-ordinate does not
exist\&. See also method \fBhas\fR\&.
.RS
.TP
string \fIname\fR
The name of the sub-ordinate to look for\&.
.RE
.TP
\fB<officer>\fR \fBprompt1\fR
This hook-method for the main shell returns the primary prompt string
to use\&.
.TP
\fB<officer>\fR \fBprompt2\fR
This hook-method for the main shell returns the secondary prompt
string for use within a continuation\&. As the main shell does not
support continuation lines it should not be invoked ever, and thus
always throws an error should it be invoked\&.
.TP
\fB<officer>\fR \fBreport\fR \fIwhat\fR \fIdata\fR
This hook-method for the main shell is responsible for the reporting
of the command results\&.
.sp
Its result is the empty string\&.
.RS
.TP
enum \fIwhat\fR
The result code of the command, one of \fBok\fR, or \fBfail\fR\&.
.TP
any \fIdata\fR
The result of the command, or an error message in case of failure\&.
.RE
.TP
\fB<officer>\fR \fBshell-exit\fR \fIconfig\fR
This is the backend for a private ending the main shell,
be it automatically created by the pacge, or by a user\&.
.sp
The argument is the \fBcmdr::config\fR
instance holding the parameters\&. The method does not
expect any and ignore it\&.
.PP
.SH "HELP INFORMATION"
The help information generated by various places of the framework
is a dictionary containing the following keys:
.TP
arguments
A list of strings, the names of the command arguments, in order\&.
These names are keys into the \fBparameters\fR sub-dictionary\&.
.TP
desc
The command's description, i\&.e\&. help text\&.
.TP
opt2para
A dictionary mapping option flags to option names\&.
These names are keys into the \fBparameters\fR sub-dictionary\&.
.TP
options
A dictionary mapping option names to their descriptions\&.
.TP
parameters
A dictionary mapping parameter names to their definition\&.
Each definition is a dictionary containing the keys below\&.
See also package \fBcmdr::parameter\fR\&.
.RS
.TP
cmdline
Output of method \fBcmdline\fR\&.
.TP
code
Output of method \fBcode\fR\&.
.TP
default
Output of method \fBdefault\fR\&.
.TP
defered
Output of method \fBdefered\fR\&.
.TP
description
Output of method \fBdescription\fR\&.
.TP
documented
Output of method \fBdocumented\fR\&.
.TP
flags
A dictionary mapping flag names to flag
types, i\&.e\&. \fBprimary\fR, \fBalias\fR,
or \fBinverted\fR\&.
.TP
generator
Output of method \fBgenerator\fR\&.
.TP
interactive
Output of method \fBinteractive\fR\&.
.TP
isbool
Output of method \fBisbool\fR\&.
.TP
label
Output of method \fBlabel\fR\&.
.TP
list
Output of method \fBlist\fR\&.
.TP
ordered
Output of method \fBordered\fR\&.
.TP
presence
Output of method \fBpresence\fR\&.
.TP
prompt
Output of method \fBprompt\fR\&.
.TP
required
Output of method \fBrequired\fR\&.
.TP
threshold
Output of method \fBthreshold\fR\&.
.TP
type
Output of method \fBtype\fR\&.
.TP
validator
Output of method \fBvalidator\fR\&.
.RE
.TP
sections
A list of sections the command belongs to\&.
Each section name is a list itself, the path of the section and sub-sections\&.
.TP
states
A list of strings, the names of the command's hidden state parameters\&.
These names are keys into the \fBparameters\fR sub-dictionary\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi