'\"
'\" Generated from file 'cmdr_howto_development\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr_development" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr_development \- Cmdr - The Developer's Guide
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
.PP
The audience of this document are anyone wishing to modify
Cmdr in any way, shape, or form\&. This can be a maintainer
fixing bugs, a developer adding functionality, or patching it to
accommodate local cicumstances, etc\&.
.PP
Please read
.IP [1]
\fICmdr - How To Get The Sources\fR and
.IP [2]
\fICmdr - The Installer's Guide\fR
.PP
first, if that was not done already\&. Here we assume that the sources
are already available in a directory of your choice, that it is known
how to build and install the project, and that all the necessary
requisites are available\&.
.SH "DEVELOPMENT TOOLS"
Cmdr requires the following tools going beyond those needed
for build and installation\&.
.TP
\fBdia\fR
Processor for \fBdiagram\fR-based figures\&.
See package \fBtklib\fR\&.
.TP
\fBdtplite\fR
Processor for \fBdoctools\fR-based documentation files, i\&.e\&. the
"\fI\&.man\fR" files under "\fIdoc/\fR"\&.
See package \fBtcllib\fR\&.
.sp
This requirement is optional\&. If a Tcllib providing the package
\fBdtplite\fR is installed then \fBkettle\fR will use the
package in favor of the external application\&.
.PP
.SH "DEMONSTRATION/EXAMPLE APPLICATIONS"
Cmdr (currently) does not have demonstrations, nor examples\&.
.SH "DIRECTORY STRUCTURE"
The directory structure of the sources is as explained below:
.TP
"\fIbuild\&.tcl\fR"
The main file of the \fBkettle\fR-based build-system\&.
.TP
"\fIdoc/\fR"
Main directory for all documentation\&.
.sp
Based on the \fBdoctools\fR package and tools provided by
\fBTcllib\fR\&.
.TP
"\fIdoc/figures/\fR"
Main directory for all diagrams and figures used by the documentation\&.
.sp
Based on the \fBdiagram\fR package and tools provided by
\fBTklib\fR\&.
.TP
"\fIembedded/\fR"
Compiled documentation (manpages and HTML)\&.
Part of the repository for
.RS
.IP [1]
easy access from the repository's web interface
(\fIembedded documentation\fR [http://fossil-scm\&.org/index\&.html/doc/tip/www/embeddeddoc\&.wiki]),
and
.IP [2]
quicker installation (no need to compile during the
installation process itself)\&.
.RE
.TP
"\fItests/\fR"
Main directory for the test-suite\&.
.sp
Based on the \fBtcltest\fR package distributed with the Tcl
core\&.
.TP
"\fIactor\&.tcl\fR"
Package \fBcmdr::actor\fR\&.
.TP
"\fIcmdr\&.tcl\fR"
Package \fBcmdr\fR\&.
.TP
"\fIconfig\&.tcl\fR"
Package \fBcmdr::config\fR\&.
.TP
"\fIhelp\&.tcl\fR"
Package \fBcmdr::help\fR\&.
.TP
"\fIhelp_json\&.tcl\fR"
Package \fBcmdr::help::json\fR\&.
.TP
"\fIhelp_sql\&.tcl\fR"
Package \fBcmdr::help::sql\fR\&.
.TP
"\fIhelp_tcl\&.tcl\fR"
Package \fBcmdr::help::tcl\fR\&.
.TP
"\fIofficer\&.tcl\fR"
Package \fBcmdr::officer\fR\&.
.TP
"\fIparameter\&.tcl\fR"
Package \fBcmdr::parameter\fR\&.
.TP
"\fIprivate\&.tcl\fR"
Package \fBcmdr::private\fR\&.
.TP
"\fIutil\&.tcl\fR"
Package \fBcmdr::util\fR\&.
.TP
"\fIvalidate\&.tcl\fR"
Package \fBcmdr::validate\fR\&.
.TP
"\fIvcommon\&.tcl\fR"
Package \fBcmdr::validate::common\fR\&.
.PP
.SH "EXTENDED BUILD ACTIONS"
Our build-system is based on \fBkettle\fR, as already explained in
the \fICmdr - The Installer's Guide\fR\&. Beyond the targets useful for
installation it also provides targets aiding developers and
maintainers\&. These are:
.TP
Validation of the documentation
.CS


% /path/to/cmdr/build\&.tcl validate-doc

.CE
.TP
Regeneration of the embedded documentation
.CS


% /path/to/cmdr/build\&.tcl doc

.CE
.TP
Regeneration of the figures for the documentation
.CS


% /path/to/cmdr/build\&.tcl figures

.CE
.TP
Execution of the test-suite
The most basic execution of the test-suite is done with
.CS


% /path/to/cmdr/build\&.tcl test

.CE
.sp
When the test-suite reports issues with the framework use of
the more extended form below is indicated, with a \fB<stem>\fR of
your choice\&. This will generate a number of files whose name starts
with the prefix "\fI<stem>\&.\fR"\&. These will contain extended test logs,
details about errors and failures, etc\&.
.CS


% /path/to/cmdr/build\&.tcl test --log <stem>

.CE
.PP
.SH "ARCHITECTURE & CONCEPTS"
.PP
All packages in the framework belong to one of three layers,
as shown below:
.PP
.PS
.nf
+--------------------------------------------+
|                    cmdr                    |
+--------------------------------------------+
| actor, officer, private, config, parameter |
+--------------------------------------------+
|           help*, util, validate*           |
+--------------------------------------------+

.fi
.PE
.PP
Note that:
.IP \(bu
Packages marked with a dashed blue border are public in parts,
and private in parts\&.
.IP \(bu
Packages marked with an unbroken blue border are fully public\&.
.IP \(bu
The topmost layer contains only a single package,
\fBcmdr\fR, which is the trivial entry point to the system\&.
.IP \(bu
The bottom layer contains the mainly internal utility packages\&.
The exception is \fBcmdr::validate::common\fR, for use in bespoke
validation types\&. See the document about \fICmdr - Writing custom validation types\fR
for details\&.
.IP \(bu
The important pieces implementing the various entities are all
in the middle layer\&. The relationship of these entities can be seen in
the next diagram:
.sp
.PS
.nf
      is-a         is-a
    /-1:1-> actor <-1:1-\\
   /                     \\
officer ---1:(0-n)--> private --1:1-> config --1:(0-n)-> parameter
 |  ^      has                  has            has
 |  |
 \\--/
 1:(0-n)
 has

.fi
.PE
.PP
.PP
The dependencies between the packages are very
straight-forward, following mostly directly out of the relationships
shown above, plus the few where the utilities are imported\&. To reduce
the complexity of the diagram below a few direct dependencies on
\fBcmdr::util\fR were omitted where indirectly present through
other dependencies (i\&.e\&. through \fBcmdr::help\fR):
.PP
IMAGE: pkg_dependencies
.SH "VALIDATION TYPES"
Everything said in the public document \fICmdr - Writing custom validation types\fR
applies to the standard validation types of the framework (as listed
in \fICmdr - Standard validation types for parameters\fR) as well\&.
.SH "HELP FORMATS"
Everything said in the public document \fICmdr - Writing custom help formats\fR
applies to the standard help formats of the framework (as listed in
\fICmdr - (Internal) Utilities for help text formatting and setup\fR) as well\&.
.SH "COMMAND LINE COMPLETION"
The document \fICmdr - Internals of command line completion\fR describes the inner
workings of the command line completion provided by the framework\&.
.SH "COMMON BLOCKS"
The framework reserves all blocks whose name begins with a star, i\&.e
\fB*\fR, for its own use\&.
Currently the following names are in use:
.TP
\fB*all*\fR
Publicly documented for users, this block is expected to contain
parameter specification commands\&. These commands are automatically
added to all privates found in the command hierarchy containing the
block\&.
.sp
The details are explained by the description of command
\fBcommon\fR in \fICmdr - Officer Specification Language\fR\&.
.TP
\fB*category-order*\fR
Publicly documented for users, this block is expected to contain a
dictionary mapping from toplevel section/category names to an integer
number to override the natural order of displaying these sections in
the help\&.
.sp
The details are explained in section \fIFormat Notes\fR of
\fICmdr - (Internal) Utilities for help text formatting and setup\fR\&.
.TP
\fB*config*\fR
Publicly documented for users as read-only this block's value is
managed by the framework, and only found in the root actor\&.
.sp
It is a command name, i\&.e\&. object handle, to the active
instance of \fBcmdr::config\fR\&. For regular parameters that is the
same handle given to them in their various callbacks\&. For a global
parameter however the active config object is what the parameter is
currently used by, whereas the callback argument is where it was
defined in and inherited from\&.
.sp
This distinction is important when the global parameter has to
look at and work with non-global parameters of the active
private\&. These can only be found in the active context\&.
.TP
\fB*prefix*\fR
Publicly documented for users as read-only this block's value is
managed by the framework\&.
Set during the \fIDispatch\fR phase it provides to access to the
actual command name used to invoke a \fIprivate\fR\&.
.sp
See also section \fIExecution\fR of \fICmdr - Runtime Processing Flow\fR\&.
.TP
\fB*in-shell*\fR
Publicly documented for users as read-only this block's value is
managed by the framework\&. Not set until the first main- or mini-shell
was active its value is boolean flag indicating if an interactive
shell is currently active (\fBtrue\fR) or not (\fBfalse\fR, or not
existing)\&.
.sp
See also section \fIExecution\fR of \fICmdr - Runtime Processing Flow\fR\&.
.PP
.SH "RELATED DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the project\fR
.IP [2]
\fICmdr - License\fR
.IP [3]
\fICmdr - Log of Changes\fR
.IP [4]
\fICmdr - How To Get The Sources\fR
.IP [5]
\fICmdr - The Installer's Guide\fR
.IP [6]
\fICmdr - The Developer's Guide\fR
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi