'\"
'\" Generated from file 'cmdr_changes\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr-changes" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr-changes \- Cmdr - Log of Changes
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This document provides an overview of the changes \fBcmdr\fR
underwent from version to version\&.
.SH CHANGES
.SS "CHANGES FOR VERSION 1\&.2"
.IP [1]
Extended the package \fBcmdr::validate\fR with many new
standard validation types:
.RS
.IP [1]
Double
.IP [2]
Percent
.IP [3]
Posint (positive integers, > 0)
.IP [4]
Paths and channels
.RS
.IP [1]
Readable file
.IP [2]
Writable file
.IP [3]
Read/writable file
.IP [4]
Readable directory
.IP [5]
Read/writeable directory
.IP [6]
readable path
.IP [7]
Read/writable path
.IP [8]
Readable path, as channel
.IP [9]
Writable path, as channel
.IP [10]
Read/writable path, as channel
.RE
.IP [5]
Date and time related:
.RS
.IP [1]
ISO-8601 date/time,
.IP [2]
year
.IP [3]
weekday,
.IP [4]
hour:minute
.RE
.RE
.IP [2]
In package \fBcmdr::validate\fR, modified the integer
validation type to have a proper internal representation:
decimal\&. Input in octal, hex, etc\&. is now normalized to this\&.
.IP [3]
Extended package \fBcmdr::validate::common\fR with more
helper commands for the generation of validation failure
messages
.RS
.IP [1]
\fBfail-unknown-thing-msg\fR
.IP [2]
\fBfail-unknown-simple\fR
.IP [3]
\fBfail-unknown-simple-msg\fR
.IP [4]
\fBfail-known-thing-msg\fR
.IP [5]
\fBfail-known-simple\fR
.IP [6]
\fBfail-known-simple-msg\fR
.RE
.IP [4]
Added various new supporting packages:
.RS
.TP
\fBcmdr::tty\fR
Test for terminal\&.
.TP
\fBcmdr::color\fR
Color management, ansi control sequences\&.
.TP
\fBcmdr::ask\fR
User interaction commands\&.
.TP
\fBcmdr::pager\fR
Text display with automatic invokation of a pager for tall
output\&.
.TP
\fBcmdr::history\fR
Pluggable management of command history\&.
.TP
\fBcmdr::table\fR
Table formatting, a simplified interface to
\fITcllib\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/toc\&.html]'s
\fBstruct::matrix\fR and \fBreport\fR packages\&.
.TP
\fBcmdr::validate::valtype-support\fR
Even more validation types, now as wrappers around the
validation commands provided by
\fITcllib\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/toc\&.html]:
.RS
.IP [1]
\fIvaltype::creditcard::amex\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/cc_amex\&.html]
.IP [2]
\fIvaltype::creditcard::discover\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/cc_discover\&.html]
.IP [3]
\fIvaltype::creditcard::mastercard\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/cc_mastercard\&.html]
.IP [4]
\fIvaltype::creditcard::visa\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/cc_visa\&.html]
.IP [5]
\fIvaltype::gs1::ean13\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/ean13\&.html]
.IP [6]
\fIvaltype::iban\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/iban\&.html]
.IP [7]
\fIvaltype::imei\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/imei\&.html]
.IP [8]
\fIvaltype::isbn\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/isbn\&.html]
.IP [9]
\fIvaltype::luhn\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/luhn\&.html]
.IP [10]
\fIvaltype::luhn5\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/luhn5\&.html]
.IP [11]
\fIvaltype::usnpi\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/usnpi\&.html]
.IP [12]
\fIvaltype::verhoeff\fR [http://core\&.tcl\&.tk/tcllib/doc/trunk/embedded/www/tcllib/files/modules/valtype/verhoeff\&.html]
.RE
.RE
.IP [5]
Extended package \fBcmdr::officer\fR with
.RS
.IP [1]
Support for per-officer options\&. The most common use
case will likely be the declaration of global options in
the root officer\&.
.sp
Related to this, a new common block \fB*config*\fR is
set to the active \fBconfig\fR instance, which will
be different from the defining instance, for per-officer
options\&. This gives the per-officer options access to
the arguments (and options) of the current command,
instead of only their own sibling options\&.
.IP [2]
Support for an option \fB-extend\fR for common
blocks, allowing their extension in a subordinate
instead of just replacing the entire content\&.
.IP [3]
Support to accept all unique command prefixes of an
officer's subordinates for dispatch\&.
.RE
.IP [6]
Extended package \fBcmdr::parameter\fR with
.RS
.IP [1]
Support for the specification of negative aliases for
boolean options, i\&.e\&. representing the inverted option\&.
.sp
See the DSL commands \fBneg-alias\fR and \fB!alias\fR in
\fICmdr - Parameter Specification Language\fR\&.
.IP [2]
Support for option labeling, for use in the generated
help, to make it more descriptive\&. Options for which no
label is specified will use their name as fallback\&.
.sp
See DSL command \fBlabel\fR in
\fICmdr - Parameter Specification Language\fR\&.
.RE
.IP [7]
Help system changes
.RS
.IP [1]
Modified it to use the \fBshort\fR format for interior
nodes of the command hierarchy by default\&.
.IP [2]
Modified it to exclude auto-added commands from the
output generated by format \fBby-category\fR\&.
.IP [3]
Modified the format \fBfull\fR to show the option
arguments for those which have such\&. See also the
extension of package \fBcmdr::parameter\fR with
support for option labels, this is what is used here\&.
.IP [4]
Modified it to declare a standard global option
\fB--help\fR (with aliases \fB-h\fR and
\fB-?\fR)\&. Using the option invokes the standard help
(command) on the current command, if any, or the global
help if there is no command\&.
.IP [5]
Modified to use a minimum width of 10 characters for
descriptions\&. If the user narrowed the terminal this far
then having the text either cut off at the right edge,
or wrapped around is not worse then the help trying to
wrap the sentence with word boundaries, etc\&. Also,
trying to use negative width threw Tcl errors\&.
.RE
.IP [8]
Fixed the handling of common block \fB*all*\fR in package
\fBcmdr::officer\fR\&. While it was ok trapping and ignoring
a missing definition of this block, trapping everything which
could go wrong was not\&.
.sp
\fIDetails\fR [http://core\&.tcl\&.tk/akupries/cmdr/info/9159f68bc35d9747]\&.
.IP [9]
Fixed a long-standing bug of package \fBcmdr::config\fR in
the forced calculation of parameter values in method
\fBForce\fR)\&. Any error in the calculations left an internal
flag set, causing future invokations to believe to be in a
recursive call and thus do nothing\&.
.sp
While this had no effect on regular operation, i\&.e\&.
with the application exiting after each command, in interactive
mode this misbehaviour disabled all checks and validations for
the command in question, and also retained old parameter
values\&.
.sp
\fIDetails\fR [http://core\&.tcl\&.tk/akupries/cmdr/info/f74095b252d4c9df]
.IP [10]
Modified the formatting of \fBcmdr::config\fR state when
interactively entering it for a private\&. Parameter names now
are shown as declared, and an additional flag character
indicates if it is inherited from above, or not\&.
.IP [11]
General fixes to testsuite, code comments, bogus variable
names, typos in error messages, etc\&.
.PP
.SS "CHANGES FOR VERSION 1\&.1"
.IP [1]
Fixed broken requirement references in the meta data of packages
\fBcmdr::help::json\fR and \fBcmdr::help::sql\fR\&.
.IP [2]
Fixed initialization issues in the help generator\&.
.IP [3]
Fixed generated help, added the application name to the output
when in a cmdr shell\&.
.IP [4]
Fixed the generation of help format \fBby-categorized\fR, when
encountering sections with sub-sections and no commands of their
own\&.
.IP [5]
Fixed bad method scoping in method \fBextend\fR of officers\&.
.IP [6]
Extended officer method \fBextend\fR to return the created
private, for immediate post-creation re-configuration\&.
.IP [7]
Extended system with new help format \fItcl\fR, and associated
package \fBcmdr::help::tcl\fR\&. Similar to format \fIjson\fR
the help is printed as a nested data structure, just using Tcl
syntax\&.
.IP [8]
Extended officers and privates with method \fBfind\fR for
path lookup of sub-ordinates\&.
.PP
.SS "CHANGES FOR VERSION 1"
This is the first release of cmdr\&.
The changes therefore describe the initial features of the system\&.
.PP
In detail:
.IP [1]
cmdr requires Tcl 8\&.5 or higher\&.
Tcl 8\&.4 or less is not supported\&.
.IP [2]
The framework provides a DSL for the declaration of a hierarchy
of commands and their parameters (named options, positional
arguments, hidden state), with help texts, type information, and
various callbacks (command actions, parameter definition,
parameter completion, type validation, command completion, etc\&.)
.IP [3]
At runtime the framework provides parsing and processing of command
lines per specifications written in that DSL, determining the command
to run, and the mapping from command line words to its parameters\&.
.IP [4]
The framework also provides shells for the interactive entry of
commands and parameters, with command line completion\&.
.IP [5]
Last, but not least is the automatic generation of command line
help for commands and parameters, based on the information provided
in a specification\&.
.PP
.SH "RELATED DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the project\fR
.IP [2]
\fICmdr - License\fR
.IP [3]
\fICmdr - Log of Changes\fR
.IP [4]
\fICmdr - How To Get The Sources\fR
.IP [5]
\fICmdr - The Installer's Guide\fR
.IP [6]
\fICmdr - The Developer's Guide\fR
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi