'\"
'\" Generated from file 'cmdr_table\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr::table" n 0\&.1 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr::table \- Cmdr - Simple Table creation
.SH SYNOPSIS
package require \fBcmdr::util \fR
.sp
\fB::cmdr::table\fR \fBgeneral\fR \fIvar\fR \fIheaders\fR \fIscript\fR
.sp
\fB::cmdr::table\fR \fBdict\fR \fIvar\fR \fIscript\fR
.sp
\fB::cmdr::table\fR \fBborders\fR ?\fIenable\fR?
.sp
\fB::cmdr::table\fR \fBshow\fR ?\fIcmd\fR\&.\&.\&.?
.sp
\fBt\fR \fBborders\fR ?\fIenable\fR?
.sp
\fBt\fR \fBheaders\fR ?\fIenable\fR?
.sp
\fBt\fR \fBstyle\fR ?\fIstyle\fR?
.sp
\fBt\fR \fBadd\fR \fIword\fR\&.\&.\&.
.sp
\fBt\fR \fB+\fR \fIword\fR\&.\&.\&.
.sp
\fBt\fR \fB+=\fR \fIword\fR\&.\&.\&.
.sp
\fBt\fR \fB<<\fR \fIword\fR\&.\&.\&.
.sp
\fBt\fR \fB<=\fR \fIword\fR\&.\&.\&.
.sp
\fBt\fR \fBshow*\fR ?\fIcmd\fR?
.sp
\fBt\fR \fBshow\fR ?\fIcmd\fR?
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This package provides convenience commands for the easy creation of
simple tables\&.
.SH API
.TP
\fB::cmdr::table\fR \fBgeneral\fR \fIvar\fR \fIheaders\fR \fIscript\fR
This command creates a new table with the words found in the list of
\fIheaders\fR as the top row\&.
The \fIscript\fR is run in the calling context to configure and
populate the table\&.
The table's object command is stored in the named \fIvar\fR for access
by the \fIscript\fR\&.
The result of the command is the table's object command\&.
.RS
.TP
varname \fIvar\fR
The name of the variable in the calling scope the new table's object
command will be stored into\&.
.TP
list \fIheaders\fR
The list of words to user as column headers\&.
.TP
string \fIscript\fR
The tcl script to be run to configure and populate the table\&.
.RE
.TP
\fB::cmdr::table\fR \fBdict\fR \fIvar\fR \fIscript\fR
This command creates a new table intended for the display of a Tcl
dictionary\&.
It will have two columns titled \fBKey\fR and \fBValue\fR\&.
The \fIscript\fR is run in the calling context to configure and
populate the table\&.
The table's object command is stored in the named \fIvar\fR for access
by the \fIscript\fR\&.
The result of the command is the table's object command\&.
.RS
.TP
varname \fIvar\fR
The name of the variable in the calling scope the new table's object
command will be stored into\&.
.TP
string \fIscript\fR
The tcl script to be run to configure and populate the table\&.
.RE
.TP
\fB::cmdr::table\fR \fBborders\fR ?\fIenable\fR?
This command configures the global \fIborder\fR setting, which
indicates the (non)use of borders by the tables of this package\&. Note
that changes to this setting influence only the tables created after
the change\&. Existing tables are not modified\&.
.sp
The result of the command is the new state of the setting\&.
.sp
If the command is called without an argument it simply returns the
current state of the setting, without making changes\&.
.sp
The default value for the setting is \fByes\fR\&.
Individual tables can override the global settings via their
\fBborders\fR method, see \fBTable API\fR\&.
.RS
.TP
boolean \fIenable\fR
The new value of the setting\&. Optional\&.
.RE
.TP
\fB::cmdr::table\fR \fBshow\fR ?\fIcmd\fR\&.\&.\&.?
This command configures the global \fIshow\fR setting, which is the
command prefix to use to print a table, if the table is not given a
specific command to use\&. Note that changes to this setting influence
only the tables created after the change\&. Existing tables are not
modified\&.
.sp
The result of the command is the new state of the setting
.sp
If the command is called without any arguments it simply
returns the current state of the setting, without making changes\&.
.sp
The default value for the setting is \fBputs\fR\&.
.RS
.TP
word \fIcmd\fR
The command prefix to use for printing a table, as varargs\&.
The prefix will be invoked with a single argument, the string
representation of the table\&.
.RE
.PP
.SH "TABLE API"
This section lists the methods available for configuration and
population of the tables created by this package\&.
.TP
\fBt\fR \fBborders\fR ?\fIenable\fR?
This is the table-level \fIborders\fR setting\&. On creation a table
inherits the global setting (See \fB::cmdr::table borders\fR)\&. If
that is not to suit then this method can be used to override it\&.
.sp
The result of the method is the new state of the setting\&. When
called without argument no change is made and the result is the
current state of the setting\&.
.TP
\fBt\fR \fBheaders\fR ?\fIenable\fR?
This method controls the visibility of the header row\&.  By default
general tables have the header row visisble, while for dict tables the
header is suppressed\&. This method allows the user to override these
defaults\&.
.sp
The result of the method is the new state of the setting\&. When
called without argument no change is made and the result is the
current state of the setting\&.
.TP
\fBt\fR \fBstyle\fR ?\fIstyle\fR?
This method allows the user to force the use of a completely custom
style\&.
Please see the documentation for the Tcllib package \fBreport\fR
on how to define table styles\&.
.sp
The package defines four styles of its own, all using the
common prefix \fBcmdr/table/\fR in their names\&.
When no custom style is set the table chooses between these based on
its \fIborders\fR and \fIheaders\fR settings\&.
.sp
The result of the method is the new state of the setting\&. When
called without argument then no change is made and the result is the
current state of the setting\&.
.sp
To revert from a custom style to the automatic choice invoke
this method with the empty string as the name of the style\&.
.TP
\fBt\fR \fBadd\fR \fIword\fR\&.\&.\&.
.TP
\fBt\fR \fB+\fR \fIword\fR\&.\&.\&.
.TP
\fBt\fR \fB+=\fR \fIword\fR\&.\&.\&.
.TP
\fBt\fR \fB<<\fR \fIword\fR\&.\&.\&.
.TP
\fBt\fR \fB<=\fR \fIword\fR\&.\&.\&.
This method adds a new row to the table, containing the given words\&.
If less words than headers are specified the row is padded with empty columns\&.
If too many words are specified the superfluous words are ignored\&.
.sp
The result of the method is the empty string\&.
.TP
\fBt\fR \fBshow*\fR ?\fIcmd\fR?
This method formats the table into a string and then invokes the
command prefix \fIcmd\fR to print that string\&. The command prefix is
run at the global namespace and level\&. If the \fIcmd\fR is not
specified the global \fIshow\fR setting is used instead\&.
.sp
The result of the method is the empty string\&.
.TP
\fBt\fR \fBshow\fR ?\fIcmd\fR?
This is a variant of method \fBshow*\fR above which not only prints
the table as above, but also destroys it\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi