[comment {-*- tcl -*- doctools manpage}]
[include parts/definitions.inc]
[vset VERSION 1.4.1]
[manpage_begin [vset LABEL_OFFICER] [vset MAN_SECTION] [vset VERSION]]
[include parts/module.inc]
[require cmdr::officer]
[titledesc [vset TITLE_OFFICER]]
[description]
[include parts/welcome.inc]

This package implements [emph officers], the inner nodes of command
hierarchies.  Each officer can execute many actions, by delegating
them to their sub-ordinate actors, officers and privates.

[para] This class is sub-class of [package cmdr::actor].

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Class API}]

The class API is not public. It is used internally by the framework
when parsing a command hierarchy specification to create the necessary
officer instances.

[para] It is described here for use by developers maintaining,
modifying and extending the framework itself. A user of the framework
has no need for it.

[list_begin definitions]
[comment {- - -- --- ----- -------- -------------}]
[call [cmd ::cmdr::officer] [method new] [arg super] [arg name] [arg actions]]

Create an auto-named instance of [class cmdr::officer].
[para] [emph {Not used}].

[comment {- - -- --- ----- -------- -------------}]
[call [cmd ::cmdr::officer] [method create] [arg obj] [arg super] [arg name] [arg actions]]

Create a new instance of [class cmdr::officer], named [arg obj].
Used by the DSL processing parts of the framework to instantiate officers.

[list_begin arguments]
[arg_def object super]
The instance command of the actor (officer actually) which contains the new officer.

[arg_def string name]
The user-visible name of the command.

[arg_def script actions]
The specification of the officer's subordinates.
Please read [term [vset TITLE_DSL_OFFICER]] for the details.

[list_end][comment arguments]
[list_end][comment definitions]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Instance API}]

The instance API is not public. It is used internally by the framework
during the parsing of a command hierarchy specification to configure
the officer instances, and when processing a command line at runtime
to manage navigation of the hierarchy, word-completion, etc.

[para] It is described here for use by developers maintaining,
modifying and extending the framework itself. A user of the framework
has no need for it.

[list_begin definitions]
[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method children]]

This method returns a list containing the instance commands of the
subordinate actors managed by this officer.

See also method [method known] which returns a list of names.

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method complete] [arg line]]

This hook-method for the main shell is responsible for computing the
set of completions for the entered [arg line].

[list_begin arguments]
[arg_def string line]
The command line to complete.
[list_end][comment {--- arguments --}]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method complete-words] [arg parse]]

This method is part of the main shell command line
completion. For the details of its workings please read
[term [vset TITLE_DEV_COMPLETE]].

[para] Given the completion state [arg parse] of a partial
command line it returns a list of strings which are the valid
completions at this point.

[list_begin arguments]
[arg_def dict parse]
A dictionary holding the current completion state of a partial command
line.
[list_end][comment arguments]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method continued] [arg line]]

This hook-method for the main shell is responsible for the detection
of a continuation-line in the entered command [arg line]. It always
returns the boolean value [const false] as the main shell does not
support continuation lines.

[list_begin arguments]
[arg_def list list]
[list_end][comment {--- arguments --}]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method default]]

This method returns the instance command of the subordinate to use
during command line processing if the first word does not specify a
known subordinate. An error is thrown if no such default was specified
for this officer. See also method [method hasdefault].

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method dispatch] [arg cmd]]

This hook-method for the main shell is responsible for the recognition
and execution of the supported commands.

[list_begin arguments]
[arg_def string cmd]
The command line containing the command to run.
[list_end][comment {--- arguments --}]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method do] [opt [arg word]...]]

This method parses the [arg word]s of the command line, matching them
to the sub-ordinates of the officer. When done without error it
recursively invokes the chosen sub-ordinate to continue processing.

[para] This represents the "Dispatch" phase of command line processing.

[list_begin arguments]
[arg_def string word]
The words of the command line to parse and match to parameters.
[list_end][comment arguments]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method intercept] [arg cmd]]
[call [cmd <officer>] [method ehandler] [arg cmd]]

[emph Note:] While the form [method ehandler] is still usable, it is
deprecated and will be removed in a future release.

This method specifies a command prefix to wrap around the parsing of
the command line for the officer, and the execution of its action.

[list_begin arguments]
[arg_def cmd-prefix cmd]
A command prefix taking a single argument, a script. The command
prefix has to execute this script in its caller's context. The script
will parse words for the officer,m and perform its action. The command
prefix then has the responsbility to perform any custom cleanup action
required by the application using the framework to prevent leakage of
data between multiple commands executed one after the other (i.e. in
an interactive shell run by the framework).
[list_end][comment arguments]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method custom-setup] [arg cmd]]

This method specifies a command prefix which will be run all the
regular setup of the officer from its specification is done, to
perform customizations.

[para] An example of this can be seen in the package
[package cmdr::history]. It provides a command
[cmd cmdr::history::attach] to add the history management commands to
the actor in question, suitable as argument to this method.

[para] When called multiple times, the specified commands
accumulate. This makes it easy to specify several indepedent
customizations.

[list_begin arguments]
[arg_def cmd-prefix cmd]
A command prefix taking a single argument, the instance command of an
[package cmd::actor]. The command prefix has full access to this actor
and can modify it as it sees fit. The common use case will be the
extension of the actor with additional subordinates.
[list_end][comment arguments]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method exit]]

This hook-method for the main shell returns a boolean value indicating
whether the main shell was stopped and has to exit ([const true]), or
not ([const false]).

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method extend] [arg path] [arg arguments] [arg action]]

A convenience method to create a "private" command underneath this
officer, with the command name [arg path] (a list of names). Any
intermediate officers are created as needed. An error is thrown if any
of the intermediates already exist as a (non-extensible) private, or
if the last command already exists.

[para] The arguments after the [arg path] match the constructor of
privates in number and semantics.

[list_begin arguments]
[arg_def script path]
The list of names specifying the route from this officer to the new
private. The last element is the name of the private command, while
the preceding names specify the intermediate officers.

[arg_def script arguments]
The specification of the private's parameters.
Please read [term [vset TITLE_DSL_PARAMETER]] for the details.

[arg_def cmd-prefix action]
The command prefix to invoke when this private is selected for
execution.  It takes a single argument, the instance command of the
hidden [package cmdr::config] container holding the private's
parameters. The result of the action, if there is any, is ignored by
the framework.

[list_end][comment arguments]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method find] [arg path]]

This method returns the instance command of the sub-ordinate with the
given [arg path] (a list) of names. An error is thrown if such a sub-ordinate
does not exist. This is an extension of [method lookup] to paths of names.

[para] An empty [arg path] is allowed and refers to the officer itself.

[list_begin arguments]
[arg_def string path] The path of names to the sub-ordinate to look for.
[list_end]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method has] [arg name]]

This method returns a boolean value indicating if this officer has a
sub-ordinate of the given [arg name] ([const true]), or not
([const false]). See also method [method lookup].

[list_begin arguments]
[arg_def string name] The name of the sub-ordinate to look for.
[list_end]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method hasdefault]]

This method returns a boolean value indicating if this officer has a
default sub-ordinate ([const true]), or not ([const false]). See also
method [method default].

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method help] [opt [arg prefix]]]

This method returns the help information for the officer and its
subordinates. The [arg prefix], if specified provides the name of the
officer within the help data. It defaults to the empty string.

The result of the command is a structure of the form
described in section [sectref {Help Information}].

[list_begin arguments]
[arg_def string prefix]
The name to use for the officer within the generated help.
[list_end][comment arguments]


[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method known]]

This method returns a list containing the names of the subordinate
actors managed by this officer.

See also method [method children] which returns a list of instance
commands.

See also method [method lookup] to map names to instance commands.

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method learn] [arg script]]

This method takes a regular specification script and uses it to extend
the set of subordinates known to this officer. This is the same type
of script as used during construction, except here we dynamically
extend the officer.

[list_begin arguments]
[arg_def script actions]
The specification of the officer's additional subordinates.
Please read [term [vset TITLE_DSL_OFFICER]] for the details.

[list_end][comment arguments]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method lookup] [arg name]]

This method returns the instance command of the sub-ordinate with the
given [arg name]. An error is thrown if such a sub-ordinate does not
exist. See also method [method has].

[list_begin arguments]
[arg_def string name] The name of the sub-ordinate to look for.
[list_end]

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method prompt1]]

This hook-method for the main shell returns the primary prompt string
to use.

[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method prompt2]]

This hook-method for the main shell returns the secondary prompt
string for use within a continuation. As the main shell does not
support continuation lines it should not be invoked ever, and thus
always throws an error should it be invoked.


[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method report] [arg what] [arg data]]

This hook-method for the main shell is responsible for the reporting
of the command results.

[para] Its result is the empty string.

[list_begin arguments]
[arg_def enum what]
The result code of the command, one of [const ok], or [const fail].

[arg_def any data]
The result of the command, or an error message in case of failure.
[list_end][comment {--- arguments --}]



[comment {- - -- --- ----- -------- -------------}]
[call [cmd <officer>] [method shell-exit] [arg config]]

This is the backend for a private ending the main shell,
be it automatically created by the pacge, or by a user.

[para] The argument is the [package cmdr::config]
instance holding the parameters. The method does not
expect any and ignore it.

[list_end][comment definitions]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Help Information}]
[include parts/help_structure.inc]

[include parts/feedback.inc]
[manpage_end]
