[comment {-*- tcl -*- doctools manpage}]
[include parts/definitions.inc]
[vset VERSION 1.2]
[manpage_begin [vset LABEL_VCOMMON] [vset MAN_SECTION] [vset VERSION]]
[include parts/module.inc]
[require cmdr::validate::common]
[titledesc [vset TITLE_VCOMMON]]
[description]
[include parts/welcome.inc]

This package publicly exports three commands for use in the
implementation of validation types.

The standard validation types defined in package
[package cmdr::validate] make use of these commands.

[section API]
[list_begin definitions][comment {-- begin api definitions --}]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail] \
     [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[include parts/fail_description.inc]

[para] The generated string has the form:
[example {
    Expected $type for $p.type "$x"$context, got "$x"
}]

[list_begin arguments]
[include parts/fail_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-unknown-thing] \
     [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[include parts/fail_description.inc]

[para] The generated string has the form:
[example {
    Found a problem with $p.type "$p.the-name":
    A(n) $type named "$x" does not exist$context.
     Please use a different value.
}]

[list_begin arguments]
[include parts/fail_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-unknown-thing-msg] \
     [arg msg] [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[vset method fail-unknown-thing][include parts/fail_desc_variant.inc]

[para] The generated string has the form:
[example {
    Found a problem with $p.type "$p.the-name":
    A(n) $type named "$x" does not exist$context.
     $msg.
}]

[list_begin arguments]
[include parts/fail_msg_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-unknown-simple] \
     [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[include parts/fail_description.inc]

[para] The generated string has the form:
[example {
    $type "$x" does not exist$context.
     Please use a different value.
}]

[list_begin arguments]
[include parts/fail_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-unknown-simple-msg] \
     [arg msg] [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[vset method fail-unknown-simple][include parts/fail_desc_variant.inc]

[para] The generated string has the form:
[example {
    $type "$x" does not exist$context.
     $msg.
}]

[list_begin arguments]
[include parts/fail_msg_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-known-thing] \
     [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[include parts/fail_description.inc]

[para] The generated string has the form:
[example {
    Found a problem with $p.type "$p.the-name":
    A(n) $type named "$x" already exists$context.
     Please use a different name.
}]

[list_begin arguments]
[include parts/fail_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-known-thing-msg] \
     [arg msg] [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[vset method fail-known-thing][include parts/fail_desc_variant.inc]

[para] The generated string has the form:
[example {
    Found a problem with $p.type "$p.the-name":
    A(n) $type named "$x" already exists$context.
     $msg.
}]

[list_begin arguments]
[include parts/fail_msg_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-known-simple] \
     [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[include parts/fail_description.inc]

[para] The generated string has the form:
[example {
    $type named "$x" already exists$context.
     Please use a different name.
}]

[list_begin arguments]
[include parts/fail_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method fail-known-simple-msg] \
     [arg msg] [arg p] [arg code] [arg type] [arg x] [opt [arg context]]]

[vset method fail-known-simple][include parts/fail_desc_variant.inc]

[para] The generated string has the form:
[example {
    $type named "$x" already exists$context.
     $msg.
}]

[list_begin arguments]
[include parts/fail_msg_args.inc]
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method complete-enum] \
     [arg choices] [arg nocase] [arg buffer]]

When invoked this command returns a list of strings containing just
the elements of [arg choices] the value of [arg buffer] is a prefix
of. When [arg nocase] is set the command will ignore letter case and
treat the string in [arg buffer] as all-lowercase.

[list_begin arguments]
[arg_def list choices]
The list of values which can complete the data in [arg buffer].

[arg_def boolean nocase]
A boolean flag specifying if the completion is done ignoring
letter-case ([const true], [const nocase]), or not ([const false])).

[arg_def string buffer]
The string to complete via the list of [arg choices].
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method complete-substr] \
     [arg choices] [arg nocase] [arg buffer]]

When invoked this command returns a list of strings containing just
the elements of [arg choices] the value of [arg buffer] is a substring
of. When [arg nocase] is set the command will ignore letter case and
treat the string in [arg buffer] as all-lowercase.

[list_begin arguments]
[arg_def list choices]
The list of values which can complete the data in [arg buffer].

[arg_def boolean nocase]
A boolean flag specifying if the completion is done ignoring
letter-case ([const true], [const nocase]), or not ([const false])).

[arg_def string buffer]
The string to complete via the list of [arg choices].
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method complete-glob] \
     [arg filter] [arg buffer]]

When invoked this command returns a list of strings, the paths in the
filesystem the value of [arg buffer] is a prefix of, and not rejected
by the [arg filter] command (prefix).

[para] Note that when the value of [arg buffer] is a relative path the
current working directory is used to locate matches.

[list_begin arguments]
[arg_def cmd-prefix filter]
A command prefix taking a single argument, the candidate path, and
returning a boolean value indicating (non-)acceptance of the path. A
result of [const true] accepts the candidate, [const false] rejects
it.

[arg_def string buffer]
The string, a partial path, to complete.
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method ok-directory] \
     [arg path]]

When invoked this command checks if the specified [arg path] is
suitable as a directory and returns the boolean value [const true] if
so, and [const false] else.

[para] for the [arg path] to be suitable the following conditions must hold:
[list_begin enumerated]
[enum] If the [arg path] exists:
[list_begin enumerated]
[enum] The path has to refer to a directory.
[enum] The referenced directory must be writable.
[list_end]
[enum] Else: 
[list_begin enumerated]
[enum] The parent path has to pass [cmd ok-directory].
[enum] The above recursion stops at the root directory, and then fails.
[list_end]
[list_end]

[list_begin arguments]
[arg_def string path]
The path to check.
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::common] [method lead-in] \
     [arg text]]

A utility command supporting the construction of error messages. Given the
[arg text] the command returns a modified text with a proper prefix of
either [const A] or [const An].

[para] The basic heuristics is to use [const An] if [arg text] begins with
a vocal, and [const A] otherwise. This heuristic is bypassed if the the
[arg text] already has a prefix of [const An] or [const A] separated by a
space from the remainder of the string. In that case the [arg text] is
returned as-is.

[para] This command is used by [cmd fail], [cmd fail-known-thing] and
[cmd fail-unknown-thing] provided by this package. All apply it to their
[arg type] argument.

[list_begin arguments]
[arg_def string text]
The string to prefix with a leading [const A] or [const An].
[list_end]

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[list_end][comment {-- end api definitions --}]
[include parts/feedback.inc]
[manpage_end]
