'\"
'\" Generated from file 'cmdr_dsl\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr-spec-dsl" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr-spec-dsl \- Cmdr - Introduction to the Specification Language
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This document is for users of the cmdr framework\&. It introduces the
domain-specific language for the specification of command hierarchies
with commands and their parameters by way of examples and then
provides links to the detailed reference documents\&.
.SH "RELATED SPECIFICATION DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the Specification Language\fR
.IP [2]
\fICmdr - Officer Specification Language\fR
.IP [3]
\fICmdr - Private Specification Language\fR
.IP [4]
\fICmdr - Parameter Specification Language\fR
.IP [5]
\fICmdr - Runtime Processing Flow\fR
.PP
.SH "INTRODUCTORY EXAMPLES"
Instead of immediately diving into the full syntax of the
specification language first a few examples to demonstrate the general
look and feel, plus basic features\&.
.SS "BASIC PRIVATE COMMANDS WITH INPUTS"
.PP
This example specifies a command line providing 3 commands for
the management of command aliases\&.
This is actually a slice of \fBstackato\fR's interface, reduced and
modified to fit here\&.
While it does not have the necessary backend procedures required to
actually run the commands, it is enough to demonstrate basic features,
namely the declaration of "privates" with "input" parameters\&.
.PP
"privates" are the actual commands, the leaves at the bottom of
the hierarchy\&. Their "inputs" are positional parameters, i\&.e\&. the
association of argument words on a command line to parameter is done
in order of occurence (on command line, and in the specification)\&.
.CS


# -*- tcl -*
package require Tcl 8\&.5
package require cmdr
package require foo-backend

cmdr create ::foo foo {
    private alias+ {
	description {
	    Create a shortcut for a command (prefix)\&.
	}
	input name {
	    The name of the new shortcut\&.
	} {
	    validate ::foo::backend::vt::notacommand
	}
	input command {
	    The command (prefix) the name will map to\&.
	} {
	    list
	}
    } ::foo::backend::alias::add

    private alias- {
	description {
	    Remove a shortcut by name\&.
	}
	input name {
	    The name of the shortcut to remove\&.
	} {
	    validate ::foo::backend::vt::aliasname
	}
    } ::foo::backend::alias::remove

    private alias? {
	description {
	    List the known aliases (shortcuts)\&.
	}
    } ::foo::backend::alias::list
}

foo do {*}$argv
exit

.CE
.PP
At the bottom of the example, just above we can also see the
very simple Tcl command which invokes the command line processing for
a list of words, here coming from \fB$argv\fR, i\&.e\&. the application's
command line\&.
.SS "SIMPLE COMMAND NESTING"
.PP
The decoupling of command names from their implementations seen
in the previous example makes it easy to re-arrange and re-label the
user visible commands without having to touch any other part of the
code\&.
.PP
This is demonstrated in the example below, moving the 3
"privates" into an "officer" and renaming them, without changing the
actions\&. Note that the parameter specifications were removed for
clarity, as they were not changed compared to the original example\&.
.PP
"officers" are named inner nodes in the command hierarchy\&. They
aggregate related commands, which may not only be "privates" as seen
here, but sub-officers as well\&.
.CS


\&.\&.\&.
cmdr create ::foo foo {
    officer alias {
	description {
	    A collection of commands to manage
	    user-specific shortcuts for command
	    entry
	}

	private add {
	    \&.\&.\&.
	} ::foo::backend::alias::add

	private remove {
	    \&.\&.\&.
	} ::foo::backend::alias::remove

	private list {
	    \&.\&.\&.
	} ::foo::backend::alias::list
    }
}
\&.\&.\&.

.CE
.SS "SIMPLE BACKEND"
.PP
This example shows a possible implementation of the backend for
the command hierarchies shown in the previous two sections\&.
It is important to note, I believe, that this backend works for both
command hierarchies, despite the changes to the command names (flat
versus nesting) they do\&.
.PP
Note further that while this example uses a
\fBnamespace ensemble\fR to organize the backend other methods are
possible too, i\&.e\&. all the various object systems for Tcl would be
suitable as well\&.
.PP
Lastly, for the sake of brevity this code is incomplete, not
showing any utility commands we may have importet from somewhere else,
nor the low-level workhorse procedures operating on the actual
alias database or whatnot\&.
.PP
.CS


# -*- tcl -*-
# # ## ### ##### ######## ############# #####################

namespace eval ::foo::backend::alias {
    namespace export list add remove
    namespace ensemble create
}

# # ## ### ##### ######## ############# #####################
## Command implementations\&.

proc ::foo::backend::alias::list {config} {
    set aliases [manager known]

    if {[$config @json]} {
	puts [jmap aliases $aliases]
	return
    }

    [table::do t {Alias Command} {
	foreach {name command} $aliases {
	    $t add $name $command
	}
    } show display]
    return
}

proc ::foo::backend::alias::add {config} {
    set name    [$config @name]
    set command [$config @command]

    manager add $name $command
    say [color green "Successfully aliased '$name' to '$command'"]
    return
}

proc ::foo::backend::alias::remove {config} {
    set name [$config @name]

    if {![manager has $name]} {
	err [color red "Unknown alias '$name'"]
    } else {
	manager remove $name
	say [color green "Successfully unaliased '$name'"]
    }
    return
}

# # ## ### ##### ######## ############# #####################
package provide  foo::backend::alias 0
# 2 lines, hidden from kettle scanner\&.

.CE
.SH "LANGUAGE REFERENCE"
With the examples behind us we can now go and specify the entire
specification language\&. If you have skipped here on first reading,
ignoring the examples, please go back and read them first\&.
.PP
The conceptual model underneath the command hierarchy is that
of a tree\&.
.PP
The inner nodes of the tree represent command ensembles, here
called \fIofficer\fRs\&. Each officer knows one or more commands to
perform, and delegates actual execution to their respective
specification, which may be another \fIofficer\fR, or a \fIprivate\fR\&.
.PP
The leaf nodes of the tree represent the individual commands,
here called \fIprivate\fRs\&.
Each \fIprivate\fR is responsible for a single action and knows how
to perform it, and the set of \fIparameter\fRs used to configure that
action at runtime\&.
.PP
The same model is graphically presented in the
Entity-Relationship-Diagram below\&.
.PP
.PS
.nf
      is-a         is-a
    /-1:1-> actor <-1:1-\\
   /                     \\
officer ---1:(0-n)--> private --1:1-> config --1:(0-n)-> parameter
 |  ^      has                  has            has
 |  |
 \\--/
 1:(0-n)
 has

.fi
.PE
.PP
The \fIactor\fR in that diagram is the common base class for the
ensembles and commands and not directly relevant to users\&.
.PP
The \fIconfig\fR on the other hand is the second interface
seen by the user, as the sole argument to the action command prefix of
\fBprivate\fR\&. See \fICmdr - Officer Specification Language\fR for the details\&.
This container, an instance of \fBcmdr::config\fR, holds all the
declared parameters of the command the action is invoked for, and
provides easy access to them through its methods at the time of
execution\&.
.PP
Please continue reading with \fICmdr - Officer Specification Language\fR\&.
.SH "RELATED DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the project\fR
.IP [2]
\fICmdr - License\fR
.IP [3]
\fICmdr - Log of Changes\fR
.IP [4]
\fICmdr - How To Get The Sources\fR
.IP [5]
\fICmdr - The Installer's Guide\fR
.IP [6]
\fICmdr - The Developer's Guide\fR
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi