[include parts/definitions.inc]
[manpage_begin [vset LABEL_INTRO] [vset MAN_SECTION] [vset PROJ_VERSION]]
[include parts/module.inc]
[titledesc [vset TITLE_INTRO]]
[description]
[include parts/welcome.inc]

The cmdr framework is a set of 12 related Tcl packages for the easy
specification of the interfaces of command line applications.

This means the declaration of the set of commands to be provided by an
application, and their parameters, be they options or positional
inputs.

At runtime the internals of the framework, guided by the chosen
specification, handle the bulk of processing [var \$::argv]. This
covers determining the requested command, mapping argument words to
command parameters, and validating them.

Additional features of the runtime are an integrated help system and
interactive command line shells with basic command and argument
completion.

[section {System Architecture}]
[include parts/architecture.inc]

[section {Command Hierarchy Specifications}]

This is a bit large for this document, and can be found in the
separate [term [vset TITLE_DSL]].

[section {Extensibility}]

While the framework as is should cover most to all of the common cases
where is always the possibility of encountering unanticipated
situations.

Because of that the framework has two places where it can be extended
to make it fit uncommon requirements.

And while the DSL document chain referenced in the previous section
does mention these as well in the appropriate places this is a bit
hidden.

So, for better visibility, an early mention:

[list_begin enumerated]

[enum] While the framework has a set of standard validation types for
checking and converting inputs these handle only very generic types of
input.

Applications often have special input requiring bespoke validation.

How to write such is explained in [term [vset TITLE_DEV_VT]].

[enum] Less often an application may require a special format for help
generated from its command hierarchy, beyond the standard formats made
available by the framework.

How to write such is explained in [term [vset TITLE_DEV_HF]].

[list_end]

[include parts/related.inc]
[include parts/feedback.inc]
[manpage_end]

