[include parts/definitions.inc]
[manpage_begin [vset LABEL_DEV] [vset MAN_SECTION] [vset PROJ_VERSION]]
[include parts/module.inc]
[titledesc [vset TITLE_DEV]]
[description]
[include parts/welcome.inc]

[para]

The audience of this document are anyone wishing to modify
[vset PTITLE] in any way, shape, or form. This can be a maintainer
fixing bugs, a developer adding functionality, or patching it to
accommodate local cicumstances, etc.

[para]

Please read

[list_begin enum]
[enum][term [vset TITLE_SOURCES]] and
[enum][term [vset TITLE_INSTALL]]
[list_end]

first, if that was not done already. Here we assume that the sources
are already available in a directory of your choice, that it is known
how to build and install the project, and that all the necessary
requisites are available.

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Development Tools}]

[vset PTITLE] requires the following tools going beyond those needed
for build and installation.

[list_begin definitions]

[def [syscmd dia]]

Processor for [package diagram]-based figures.
See package [package tklib].

[def [syscmd dtplite]]

Processor for [package doctools]-based documentation files, i.e. the
[file .man] files under [file doc/].
See package [package tcllib].

[para] This requirement is optional. If a Tcllib providing the package
[package dtplite] is installed then [syscmd kettle] will use the
package in favor of the external application.

[list_end]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Demonstration/Example Applications}]

[vset PTITLE] (currently) does not have demonstrations, nor examples.

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Directory structure}]

The directory structure of the sources is as explained below:

[list_begin definitions]
[include parts/layout_standard.inc]

[def [file actor.tcl]]     Package [package cmdr::actor].
[def [file cmdr.tcl]]      Package [package cmdr].
[def [file config.tcl]]    Package [package cmdr::config].
[def [file help.tcl]]      Package [package cmdr::help].
[def [file help_json.tcl]] Package [package cmdr::help::json].
[def [file help_sql.tcl]]  Package [package cmdr::help::sql].
[def [file help_tcl.tcl]]  Package [package cmdr::help::tcl].
[def [file officer.tcl]]   Package [package cmdr::officer].
[def [file parameter.tcl]] Package [package cmdr::parameter].
[def [file private.tcl]]   Package [package cmdr::private].
[def [file util.tcl]]      Package [package cmdr::util].
[def [file validate.tcl]]  Package [package cmdr::validate].
[def [file vcommon.tcl]]   Package [package cmdr::validate::common].
[list_end]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Extended Build Actions}]
[include parts/build-dev.inc]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Architecture & Concepts}]

[include parts/architecture.inc]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Validation Types}]

Everything said in the public document [term [vset TITLE_DEV_VT]]
applies to the standard validation types of the framework (as listed
in [term [vset TITLE_VALIDATE]]) as well.

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Help Formats}]

Everything said in the public document [term [vset TITLE_DEV_HF]]
applies to the standard help formats of the framework (as listed in
[term [vset TITLE_HELP]]) as well.

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Command Line Completion}]

The document [term [vset TITLE_DEV_COMPLETE]] describes the inner
workings of the command line completion provided by the framework.

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[section {Common Blocks}]

The framework reserves all blocks whose name begins with a star, i.e
[const *], for its own use.

Currently the following names are in use:

[list_begin definitions]
[def [const *all*]]
Publicly documented for users, this block is expected to contain
parameter specification commands. These commands are automatically
added to all privates found in the command hierarchy containing the
block.

[para] The details are explained by the description of command
[cmd common] in [term [vset TITLE_DSL_OFFICER]].

[def [const *category-order*]]

Publicly documented for users, this block is expected to contain a
dictionary mapping from toplevel section/category names to an integer
number to override the natural order of displaying these sections in
the help.

[para] The details are explained in section [term {Format Notes}] of
[term [vset TITLE_HELP]].


[def [const *config*]]

Publicly documented for users as read-only this block's value is
managed by the framework, and only found in the root actor.

[para] It is a command name, i.e. object handle, to the active
instance of [class cmdr::config]. For regular parameters that is the
same handle given to them in their various callbacks. For a global
parameter however the active config object is what the parameter is
currently used by, whereas the callback argument is where it was
defined in and inherited from.

[para] This distinction is important when the global parameter has to
look at and work with non-global parameters of the active
private. These can only be found in the active context.

[def [const *prefix*]]

Publicly documented for users as read-only this block's value is
managed by the framework.

Set during the [term Dispatch] phase it provides to access to the
actual command name used to invoke a [term private].

[para] See also section [term Execution] of [term [vset TITLE_FLOW]].

[def [const *in-shell*]]

Publicly documented for users as read-only this block's value is
managed by the framework. Not set until the first main- or mini-shell
was active its value is boolean flag indicating if an interactive
shell is currently active ([const true]) or not ([const false], or not
existing).

[para] See also section [term Execution] of [term [vset TITLE_FLOW]].

[list_end]

[comment @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@]
[include parts/related.inc]
[include parts/feedback.inc]
[manpage_end]
