'\"
'\" Generated from file 'cmdr_vcommon\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr::validate::common" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr::validate::common \- Cmdr - Utilities for Validation Types
.SH SYNOPSIS
package require \fBcmdr::validate::common \fR
.sp
\fB::cmdr::validate::common\fR \fBfail\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-unknown-thing\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-unknown-thing-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-unknown-simple\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-unknown-simple-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-known-thing\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-known-thing-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-known-simple\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBfail-known-simple-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
.sp
\fB::cmdr::validate::common\fR \fBcomplete-enum\fR \fIchoices\fR \fInocase\fR \fIbuffer\fR
.sp
\fB::cmdr::validate::common\fR \fBcomplete-substr\fR \fIchoices\fR \fInocase\fR \fIbuffer\fR
.sp
\fB::cmdr::validate::common\fR \fBcomplete-glob\fR \fIfilter\fR \fIbuffer\fR
.sp
\fB::cmdr::validate::common\fR \fBok-directory\fR \fIpath\fR
.sp
\fB::cmdr::validate::common\fR \fBlead-in\fR \fItext\fR
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This package publicly exports three commands for use in the
implementation of validation types\&.
The standard validation types defined in package
\fBcmdr::validate\fR make use of these commands\&.
.SH API
.TP
\fB::cmdr::validate::common\fR \fBfail\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    Expected $type for $p\&.type "$x"$context, got "$x"

.CE
.RS
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-unknown-thing\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    Found a problem with $p\&.type "$p\&.the-name":
    A(n) $type named "$x" does not exist$context\&.
     Please use a different value\&.

.CE
.RS
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-unknown-thing-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
A variant of \fBfail-unknown-thing\fR which takes an additional
user-specified message text as the first argument\&.
.sp
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    Found a problem with $p\&.type "$p\&.the-name":
    A(n) $type named "$x" does not exist$context\&.
     $msg\&.

.CE
.RS
.TP
string \fImsg\fR
A custom message to put into the generated error message\&.
See the example above\&.
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-unknown-simple\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    $type "$x" does not exist$context\&.
     Please use a different value\&.

.CE
.RS
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-unknown-simple-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
A variant of \fBfail-unknown-simple\fR which takes an additional
user-specified message text as the first argument\&.
.sp
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    $type "$x" does not exist$context\&.
     $msg\&.

.CE
.RS
.TP
string \fImsg\fR
A custom message to put into the generated error message\&.
See the example above\&.
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-known-thing\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    Found a problem with $p\&.type "$p\&.the-name":
    A(n) $type named "$x" already exists$context\&.
     Please use a different name\&.

.CE
.RS
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-known-thing-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
A variant of \fBfail-known-thing\fR which takes an additional
user-specified message text as the first argument\&.
.sp
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    Found a problem with $p\&.type "$p\&.the-name":
    A(n) $type named "$x" already exists$context\&.
     $msg\&.

.CE
.RS
.TP
string \fImsg\fR
A custom message to put into the generated error message\&.
See the example above\&.
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-known-simple\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    $type named "$x" already exists$context\&.
     Please use a different name\&.

.CE
.RS
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBfail-known-simple-msg\fR \fImsg\fR \fIp\fR \fIcode\fR \fItype\fR \fIx\fR ?\fIcontext\fR?
A variant of \fBfail-known-simple\fR which takes an additional
user-specified message text as the first argument\&.
.sp
When invoked this command throws an error indicating a validation type
failure\&. The arguments provide the information used to construct both
error message and code\&.
.sp
The generated string has the form:
.CS


    $type named "$x" already exists$context\&.
     $msg\&.

.CE
.RS
.TP
string \fImsg\fR
A custom message to put into the generated error message\&.
See the example above\&.
.TP
\fBcmdr::parameter\fR \fIp\fR
The \fBcmdr::parameter\fR instance whose validation failed\&.
The error message will contain this parameter's type and label
(flag in case of an option)\&.
.TP
list \fIcode\fR
A list of additional elements for the error code to throw\&.
Should detail the internal name of the validation type triggering the
error\&.
.TP
string \fItype\fR
A string holding a human-readable name for the validation type
triggering the error\&. (Conversely to the \fIcode\fR, which is for
machine-readability, i\&.e\&. trapping)
.TP
string \fIx\fR
The string value which failed the validation\&.
.TP
string \fIcontext\fR
Additional context to show in the message\&.
Defaults to the empty string\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBcomplete-enum\fR \fIchoices\fR \fInocase\fR \fIbuffer\fR
When invoked this command returns a list of strings containing just
the elements of \fIchoices\fR the value of \fIbuffer\fR is a prefix
of\&. When \fInocase\fR is set the command will ignore letter case and
treat the string in \fIbuffer\fR as all-lowercase\&.
.RS
.TP
list \fIchoices\fR
The list of values which can complete the data in \fIbuffer\fR\&.
.TP
boolean \fInocase\fR
A boolean flag specifying if the completion is done ignoring
letter-case (\fBtrue\fR, \fBnocase\fR), or not (\fBfalse\fR))\&.
.TP
string \fIbuffer\fR
The string to complete via the list of \fIchoices\fR\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBcomplete-substr\fR \fIchoices\fR \fInocase\fR \fIbuffer\fR
When invoked this command returns a list of strings containing just
the elements of \fIchoices\fR the value of \fIbuffer\fR is a substring
of\&. When \fInocase\fR is set the command will ignore letter case and
treat the string in \fIbuffer\fR as all-lowercase\&.
.RS
.TP
list \fIchoices\fR
The list of values which can complete the data in \fIbuffer\fR\&.
.TP
boolean \fInocase\fR
A boolean flag specifying if the completion is done ignoring
letter-case (\fBtrue\fR, \fBnocase\fR), or not (\fBfalse\fR))\&.
.TP
string \fIbuffer\fR
The string to complete via the list of \fIchoices\fR\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBcomplete-glob\fR \fIfilter\fR \fIbuffer\fR
When invoked this command returns a list of strings, the paths in the
filesystem the value of \fIbuffer\fR is a prefix of, and not rejected
by the \fIfilter\fR command (prefix)\&.
.sp
Note that when the value of \fIbuffer\fR is a relative path the
current working directory is used to locate matches\&.
.RS
.TP
cmd-prefix \fIfilter\fR
A command prefix taking a single argument, the candidate path, and
returning a boolean value indicating (non-)acceptance of the path\&. A
result of \fBtrue\fR accepts the candidate, \fBfalse\fR rejects
it\&.
.TP
string \fIbuffer\fR
The string, a partial path, to complete\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBok-directory\fR \fIpath\fR
When invoked this command checks if the specified \fIpath\fR is
suitable as a directory and returns the boolean value \fBtrue\fR if
so, and \fBfalse\fR else\&.
.sp
for the \fIpath\fR to be suitable the following conditions must hold:
.RS
.IP [1]
If the \fIpath\fR exists:
.RS
.IP [1]
The path has to refer to a directory\&.
.IP [2]
The referenced directory must be writable\&.
.RE
.IP [2]
Else:
.RS
.IP [1]
The parent path has to pass \fBok-directory\fR\&.
.IP [2]
The above recursion stops at the root directory, and then fails\&.
.RE
.RE
.RS
.TP
string \fIpath\fR
The path to check\&.
.RE
.TP
\fB::cmdr::validate::common\fR \fBlead-in\fR \fItext\fR
A utility command supporting the construction of error messages\&. Given the
\fItext\fR the command returns a modified text with a proper prefix of
either \fBA\fR or \fBAn\fR\&.
.sp
The basic heuristics is to use \fBAn\fR if \fItext\fR begins with
a vocal, and \fBA\fR otherwise\&. This heuristic is bypassed if the the
\fItext\fR already has a prefix of \fBAn\fR or \fBA\fR separated by a
space from the remainder of the string\&. In that case the \fItext\fR is
returned as-is\&.
.sp
This command is used by \fBfail\fR, \fBfail-known-thing\fR and
\fBfail-unknown-thing\fR provided by this package\&. All apply it to their
\fItype\fR argument\&.
.RS
.TP
string \fItext\fR
The string to prefix with a leading \fBA\fR or \fBAn\fR\&.
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi