'\"
'\" Generated from file 'cmdr_color\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr::color" n 1\&.0\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr::color \- Cmdr - Terminal colors
.SH SYNOPSIS
package require \fBcmdr::tty \fR
.sp
package require \fBcmdr::color \fR
.sp
\fB::cmdr::color\fR \fBactivate\fR ?\fIenable\fR?
.sp
\fB::cmdr::color\fR \fBactive\fR
.sp
\fB::cmdr::color\fR \fBnames\fR
.sp
\fB::cmdr::color\fR \fBget\fR \fIname\fR
.sp
\fB::cmdr::color\fR \fBget-def\fR \fIname\fR
.sp
\fB::cmdr::color\fR \fBdefine\fR \fIname\fR \fIspec\fR
.sp
\fB::cmdr::color\fR \fBexists\fR \fIname\fR
.sp
\fB::cmdr::color\fR \fBunset\fR \fIname\fR
.sp
\fB::cmdr::color\fR \fB\&.\&.\&.\fR ?\fItext\fR?
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This package provides a few utility commands implementing
the management of terminal colors\&.
.SH API
.TP
\fB::cmdr::color\fR \fBactivate\fR ?\fIenable\fR?
When invoked this command enables or disables color handling,
as per the boolean flag \fIenable\fR\&. If \fIenable\fR is not
specified the action defaults to activation\&.
.sp
The result of the command is the new activation state\&.
.sp
The default activation state of the package after loading
depends on \fBstdout\fR\&. The package is active if \fBstdout\fR
is a terminal, and inactive otherwise\&.
.RS
.TP
boolean \fIenable\fR
If set, enable color handling, else disable it\&.
.RE
.TP
\fB::cmdr::color\fR \fBactive\fR
The result of this command is the current activation state
of the package\&.
.sp
The default activation state of the package after loading
depends on \fBstdout\fR\&. The package is active if \fBstdout\fR
is a terminal, and inactive otherwise\&.
.TP
\fB::cmdr::color\fR \fBnames\fR
When invoked this command returns a list of the symbolic color
names known to the package\&.
.TP
\fB::cmdr::color\fR \fBget\fR \fIname\fR
When invoked this command returns the character sequence
associated with the symbolic color \fIname\fR\&. An error
is thrown if \fIname\fR is not a known symbol\&.
.TP
\fB::cmdr::color\fR \fBget-def\fR \fIname\fR
When invoked this command returns the specification
associated with the symbolic color \fIname\fR\&. An error
is thrown if \fIname\fR is not a known symbol\&.
.TP
\fB::cmdr::color\fR \fBdefine\fR \fIname\fR \fIspec\fR
When invoked this command defines the color \fIname\fR\&. If \fIname\fR
exists already its previous specification is overwritten\&.
The command accepts four forms of \fIspec\fRifications, namely:
.RS
.TP
=\fBrname\fR
The \fIrname\fR must be the name of a known color\&.
The \fIname\fR itself is not allowed, i\&.e\&. self-references are forbidden\&.
.TP
%\fBR\fR,\fBG\fR,\fBB\fR
The \fIR\fR, \fIG\fR, and \fIB\fR values are integers in the range
\fB0\fR\&.\&.\&.\fB5\fR directly specifying the chosen color\&. These
specifications may not work if the terminal is not configured to
support 256 colors\&.
.TP
[Ee]\fBcode\fR(,\&.\&.\&.)
The value is a comma-separated list of ANSI color control characters\&.
.TP
*
Any other string is acceptable too, and used as is\&.
.RE
.TP
\fB::cmdr::color\fR \fBexists\fR \fIname\fR
When invoked this command tests if the symbolic color \fIname\fR
is known, returns the boolean value \fBtrue\fR if so, and
\fBfalse\fR else\&.
.TP
\fB::cmdr::color\fR \fBunset\fR \fIname\fR
When invoked this command deletes the symbolic color \fIname\fR\&.
An error is thrown if \fIname\fR is not a known symbol\&.
The command returns the empty string as its result\&.
.TP
\fB::cmdr::color\fR \fB\&.\&.\&.\fR ?\fItext\fR?
When \fB::cmdr::color\fR is invoked with an unknown method name then
this name is expected to be and treated as a list of known symbolic
color names\&. These colors are applied to the \fItext\fR, with a return
to base after, and the modified text is returned as the result of the
command\&.
.sp
Note however, if the \fItext\fR is the empty string, then that
string is returned, as the colorization would a \fBno-op\fR,
i\&.e\&. superfluous\&.
.sp
If the \fItext\fR is not specified at all then the method
returns just the application of the colors (without return to base)\&.
.sp
An error is thrown if any of the specified color symbols
are not known\&.
.PP
.SH "PREDEFINED COLORS"
The following colors are defined by the package itself:
.TP
black
e30
.TP
red
e31
.TP
green
e32
.TP
yellow
e33
.TP
blue
e34
.TP
magenta
e35
.TP
cyan
e36
.TP
white
e37
.TP
default
e39
.TP
bg-black
e40
.TP
bg-red
e41
.TP
bg-green
e42
.TP
bg-yellow
e43
.TP
bg-blue
e44
.TP
bg-magenta
e45
.TP
bg-cyan
e46
.TP
bg-white
e47
.TP
bg-default
e49
.TP
bold
e1
.TP
dim
e2
.TP
italic
e3
.TP
underline
e4
.TP
blink
e5
.TP
revers
e7
.TP
hidden
e8
.TP
strike
e9
.TP
no-bold
e21
.TP
no-dim
e22
.TP
no-italic
e23
.TP
no-underline
e24
.TP
no-blink
e25
.TP
no-revers
e27
.TP
no-hidden
e28
.TP
no-strike
e29
.TP
reset
e0
.TP
advisory
=yellow
.TP
bad
=red
.TP
confirm
=red
.TP
error
=magenta
.TP
good
=green
.TP
name
=blue
.TP
neutral
=blue
.TP
no
=red
.TP
note
=blue
.TP
number
=green
.TP
prompt
=blue
.TP
unknown
=cyan
.TP
warning
=yellow
.TP
yes
=green
.TP
heading
=bold
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi