'\"
'\" Generated from file 'cmdr_helpformats\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr-user-helpformats" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr-user-helpformats \- Cmdr - Writing custom help formats
.SH SYNOPSIS
package require \fBcmdr::help \fR
.sp
\fB::cmdr::help::format::<foo>\fR \fIroot\fR \fIwidth\fR \fIhelp\fR
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This document describes the API expected of \fIhelp formats\fR
to make them usable within the Cmdr framework, and how to
write a custom help format\&.
.PP
Readers interested in the standard help formats of the
framework should read \fICmdr - (Internal) Utilities for help text formatting and setup\fR\&.
.SH BACKGROUND
Help formats are Cmdr's way of converting in-memory
information about a command hierarchy into something usable for human
consumption and obviating the need for writing separate documentation,
which may easily get out of sync with the specification\&.
.PP
The system was made extensible for while the standard formats
listed in \fICmdr - (Internal) Utilities for help text formatting and setup\fR should cover the common cases, and
the json format of \fICmdr - Formatting help as JSON object\fR is a general export,
it is always possible to run into unprediced non-standard situations
not covered as is\&.
.SH API
For the framework to automatically pick up a new help format
\fBfoo\fR the package implementing it has to specify a single
command \fB::cmdr::help::format::<\fBfoo\fR>\fR, and this package has
to be loaded before the command hierarchy you want to use it for is
specified\&.
.PP
In more detail:
.TP
\fB::cmdr::help::format::<foo>\fR \fIroot\fR \fIwidth\fR \fIhelp\fR
This command, having access to the root actor of a command hierarchy,
the number of columns to format the help towards, and a help data
structure itself, has to return a string, the formatted help generated
from the arguments\&.
.RS
.TP
cmdr::officer \fIroot\fR
The root officer of the command hierarchy\&.
With the exception of \fBby-category\fR the standard formats do not
use this argument\&. By providing it the format has access to the
toplevel common blocks, allowing for the transfer of custom
information from the specifiction to the format\&.
.sp
\fBby-category\fR for example looks for and uses the block
\fB*category-order*\fR for when the user wishes to override the
natural (alphabetical) order of display for the toplevel sections\&.
.TP
integer \fIwidth\fR
The number of columns to format the help towards\&.
.TP
dictionary \fIhelp\fR
A dictonary holding the help information to format\&. For more details
see section \fBHelp Dictionary\fR\&.
.RE
.PP
.SH "HELP DICTIONARY"
The help information generated by various places of the framework
is a dictionary containing the following keys:
.TP
arguments
A list of strings, the names of the command arguments, in order\&.
These names are keys into the \fBparameters\fR sub-dictionary\&.
.TP
desc
The command's description, i\&.e\&. help text\&.
.TP
opt2para
A dictionary mapping option flags to option names\&.
These names are keys into the \fBparameters\fR sub-dictionary\&.
.TP
options
A dictionary mapping option names to their descriptions\&.
.TP
parameters
A dictionary mapping parameter names to their definition\&.
Each definition is a dictionary containing the keys below\&.
See also package \fBcmdr::parameter\fR\&.
.RS
.TP
cmdline
Output of method \fBcmdline\fR\&.
.TP
code
Output of method \fBcode\fR\&.
.TP
default
Output of method \fBdefault\fR\&.
.TP
defered
Output of method \fBdefered\fR\&.
.TP
description
Output of method \fBdescription\fR\&.
.TP
documented
Output of method \fBdocumented\fR\&.
.TP
flags
A dictionary mapping flag names to flag
types, i\&.e\&. \fBprimary\fR, \fBalias\fR,
or \fBinverted\fR\&.
.TP
generator
Output of method \fBgenerator\fR\&.
.TP
interactive
Output of method \fBinteractive\fR\&.
.TP
isbool
Output of method \fBisbool\fR\&.
.TP
label
Output of method \fBlabel\fR\&.
.TP
list
Output of method \fBlist\fR\&.
.TP
ordered
Output of method \fBordered\fR\&.
.TP
presence
Output of method \fBpresence\fR\&.
.TP
prompt
Output of method \fBprompt\fR\&.
.TP
required
Output of method \fBrequired\fR\&.
.TP
threshold
Output of method \fBthreshold\fR\&.
.TP
type
Output of method \fBtype\fR\&.
.TP
validator
Output of method \fBvalidator\fR\&.
.RE
.TP
sections
A list of sections the command belongs to\&.
Each section name is a list itself, the path of the section and sub-sections\&.
.TP
states
A list of strings, the names of the command's hidden state parameters\&.
These names are keys into the \fBparameters\fR sub-dictionary\&.
.PP
.SH EXAMPLE
As an example the implementation of the standard help format
\fBlist\fR is shown here\&.
.CS


# Entrypoint
proc ::cmdr::help::format::list {root width help} {
    set result {}
    dict for {cmd desc} $help {
	lappend result [List $width $cmd $desc]
    }
    return [join $result \\n]
}

# Main work procedure for commands
proc ::cmdr::help::format::List {width name command} {
    dict with command {} ; # -> desc, options, arguments, parameters

    # Short line\&.
    lappend lines  [string trimright  "    [join $name] [HasOptions $options][Arguments $arguments $parameters]"]
    return [join $lines \\n]
}

# Support procedures
proc ::cmdr::help::format::HasOptions {options} {
    if {[dict size $options]} {
	return "\\[OPTIONS\\] "
    } else {
	return {}
    }
}

proc ::cmdr::help::format::Arguments {arguments parameters} {
    set result {}
    foreach a $arguments {
	set v [dict get $parameters $a]
	dict with v {} ; # -> code, desc, label
	switch -exact -- $code {
	    +  { set text "<$label>" }
	    ?  { set text "\\[<${label}>\\]" }
	    +* { set text "<${label}>\&.\&.\&." }
	    ?* { set text "\\[<${label}>\&.\&.\&.\\]" }
	}
	lappend result $text
    }
    return [join $result]
}

.CE
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi