'\"
'\" Generated from file 'cmdr_dsl_officer\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr-spec-dsl-officer" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr-spec-dsl-officer \- Cmdr - Officer Specification Language
.SH SYNOPSIS
\fBalias\fR \fIname\fR \fB=\fR \fIname'\fR\&.\&.\&.
.sp
\fBalias\fR \fIname\fR
.sp
\fBcommon\fR \fIname\fR \fB-extend\fR \fB--\fR \fItext\fR
.sp
\fBdefault\fR
.sp
\fBdescription\fR \fItext\fR
.sp
\fBintercept\fR \fIcmdprefix\fR
.sp
\fBehandler\fR \fIcmdprefix\fR
.sp
\fBcustom-setup\fR \fIcmdprefix\fR
.sp
\fBofficer\fR \fIname\fR \fIscript\fR
.sp
\fBprivate\fR \fIname\fR \fIscript\fR \fIcmdprefix\fR
.sp
\fBundocumented\fR
.sp
.BE
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
This document is for users of the cmdr framework\&. It introduces the
domain-specific language for the specification of \fIofficer\fRs in
detail\&.
.SH "RELATED SPECIFICATION DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the Specification Language\fR
.IP [2]
\fICmdr - Officer Specification Language\fR
.IP [3]
\fICmdr - Private Specification Language\fR
.IP [4]
\fICmdr - Parameter Specification Language\fR
.IP [5]
\fICmdr - Runtime Processing Flow\fR
.PP
.SH "LANGUAGE REFERENCE"
.TP
\fBalias\fR \fIname\fR \fB=\fR \fIname'\fR\&.\&.\&.
.TP
\fBalias\fR \fIname\fR
This is a structuring command, for the command hierarchy\&. Its main
uses are the creation of alternate command names, and of shortcuts
through the command hierarchy\&.
.sp
For example, \fBstackato\fR's command specification for
alias management is written using deep nesting and uses aliases to
provide the look of a flat namespace to application users\&.
.sp
In the first form the \fIname\fR is given the explicit path to
the actor the name is an alias for\&.
In the second form the alias implicitly refers to the immediately
preceding \fIofficer\fR or \fIprivate\fR\&.
Note that "immediately" is interpreted at the current level\&. The
system is \fInot\fR looking into a nested specification for its last
command\&.
.RS
.TP
string \fIname\fR
The name of the alias\&.
.TP
string \fIname'\&.\&.\&.\fR
The path to the actor, as list of names\&.
.RE
.TP
\fBcommon\fR \fIname\fR \fB-extend\fR \fB--\fR \fItext\fR
This is another structuring command, for structuring the specification
itself instead of the command tree it declares\&.
.sp
It creates named values, usually code blocks, which can be
shared between specifications\&. Note that while each block is visible
in the current \fIofficer\fR and its subordinates, parents and
siblings have no access\&.
.sp
An example of such a block would be
.CS


common *all* {
    option debug {
	Activate client internal tracing\&.
    } {
	undocumented
	list
	when-complete [lambda {p tags} {
	    foreach t $tags { debug on $t }
	}]
    }
}

.CE
.IP
This example defines an option to access the subsystem for debug
narative (See package \fBTcllib\fR)\&.
The example is actually special, as the block named \fB*all*\fR is
reserved by the framework\&.
This block, if defined, is automatically included at the front of all
\fIprivate\fR specifications, i\&.e\&. shared across all the privates
specified underneath this \fIofficer\fR\&. A very important trait for
the \fIoption\fR in the example, as it makes the debug setup
available to all privates without having to explicitly include the
block, and possibly forgetting such\&.
.sp
Generally speaking, the framework reserves all blocks whose
name begins with a star, i\&.e \fB*\fR, for its own use\&.
.sp
Using option \fB-extend\fR will change the behaviour to
extend inherited content instead of writing over it\&.
.sp
Using option \fB--\fR will prevent misinterpretation of the
following argument as option, even if it begins with a dash\&.
.RS
.TP
string \fIname\fR
The name of the common block\&.
.TP
string \fItext\fR
The text of the block\&.
.RE
.TP
\fBdefault\fR
This command sets up a special kind of alias\&.
The last \fIprivate\fR or \fIofficer\fR is set as the default
command to use at runtime\&.
This means that if during "Dispatch" phase the currently processed
word does not match any of the commands known to this \fIofficer\fR
this default is used\&. If no default is specified an error will be
thrown instead\&.
.TP
\fBdescription\fR \fItext\fR
This command declares the help text of the \fIofficer\fR\&.
.TP
\fBintercept\fR \fIcmdprefix\fR
.TP
\fBehandler\fR \fIcmdprefix\fR
\fINote:\fR While the form \fBehandler\fR is still usable, it is
deprecated and will be removed in a future release\&.
This is an advanced command which should normally only be specified at
the top of the whole hierarchy (from which its value will
automatically propagate to all subordinates)\&.
.sp
At runtime the framework will call the specified command prefix
with a single argument, a script whose execution is equivalent to the
phases \fIParsing\fR, \fICompletion\fR, and \fIExecution\fR of the
framework, as described in \fICmdr - Runtime Processing Flow\fR\&.
The handler \fImust\fR call this script, and can perform any
application-specific actions before and after\&.
.sp
This handler's main uses are two-fold:
.RS
.IP [1]
Capture and hande application-specific errors which should not
abort the application, nor shown as Tcl stacktrace\&.
.IP [2]
Cleanup of application-specific transient state the
\fIparameter\fR callbacks (See \fICmdr - Parameter Specification Language\fR)
and/or actions may have set during their execution\&.
This is especially important if the interactive command line shells of
the framework are enabled\&. Without such a handler and its bespoke
cleanup code transient state \fIwill\fR leak between multiple
commands run from such a shell, something which is definitely not
wanted\&.
.RE
.TP
\fBcustom-setup\fR \fIcmdprefix\fR
This is an advanced command which should normally only be specified at
the top of the whole hierarchy (from which its value will
automatically propagate to all subordinates)\&.
.sp
When called multiple times, the specified commands
accumulate\&. This makes it easy to specify several indepedent
customizations\&.
.sp
At runtime the framework will invoke all the specified commands
with a single argument, the command of the actor to initialize\&.
The command prefix is then allowed to modify that actor as it sees
fit\&. The common use case will be the extension of the object with
additional subordinates\&.
An example of this is the package \fBcmdr::history\fR which
provides a command \fBcmdr::history::attach\fR to add the history
management commands to the actor in question\&.
.TP
\fBofficer\fR \fIname\fR \fIscript\fR
This command creates a named subordinate \fIofficer\fR with its
specification \fIscript\fR of officer commands as described here\&.
.TP
\fBprivate\fR \fIname\fR \fIscript\fR \fIcmdprefix\fR
This command creates a named subordinate \fIprivate\fR with its
specification \fIscript\fR of private commands
(See \fICmdr - Private Specification Language\fR), and a command prefix to invoke
when it is chosen\&.
.sp
This command prefix is called with a single argument, the
\fBcmdr::config\fR instance holding the \fIparameter\fRs of the
private\&.
.sp
For an example see section \fISimple backend\fR
of \fICmdr - Introduction to the Specification Language\fR\&.
.TP
\fBundocumented\fR
This command excludes the \fIofficer\fR (and its subordinates) from
the generated help\&.
Note that subordinates reachable through aliases may be included,
under the alias name, if they are not explicitly excluded themselves\&.
.PP
.PP
Please continue reading with \fICmdr - Private Specification Language\fR\&.
.SH "RELATED DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the project\fR
.IP [2]
\fICmdr - License\fR
.IP [3]
\fICmdr - Log of Changes\fR
.IP [4]
\fICmdr - How To Get The Sources\fR
.IP [5]
\fICmdr - The Installer's Guide\fR
.IP [6]
\fICmdr - The Developer's Guide\fR
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi