'\"
'\" Generated from file 'cmdr_howto_installation\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2013-2016 Andreas Kupries
'\" Copyright (c) 2013-2016 Documentation, Andreas Kupries
'\"
.TH "cmdr-installation" n 1\&.2 doc "Cmdr, a framework for command line parsing and dispatch"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdr-installation \- Cmdr - The Installer's Guide
.SH DESCRIPTION
.PP
Welcome to the Cmdr project, written by Andreas Kupries\&.
.PP
For availability please read \fICmdr - How To Get The Sources\fR\&.
.PP
.PP
The audience of this document are anyone wishing to build the
Cmdr project, for either themselves, or others\&.
.PP
If you are a developer intending to extend or modify the project
please see the list of \fBRelated Documents\fR for references to
more information on this topic\&.
.PP
Please read \fICmdr - How To Get The Sources\fR first, if that was not done
already\&. Here we assume that the sources are already available in a
directory of your choice\&.
.PP
.SH REQUISITES
.SS TCL
This project requires a working installation of Tcl 8\&.5, or higher\&.
.PP
Use whatever you are comfortable with, as long as it provides
Tcl 8\&.5, or higher\&.
.PP
An easy way to get a proper installation of a recent Tcl 8\&.5,
(which I recommend) is to download and install
\fIActiveState's\fR [http://www\&.activestate\&.com]
\fIActiveTcl 8\&.5\fR [http://www\&.activestate\&.com/activetcl]
for your platform\&. Just follow the link and instruction on that site\&.
.PP
After the installation of ActiveTcl 8\&.5 simply run the command
.CS


    teacup update

.CE
This will install a lot more packages than found in the distribution
alone\&.
(Disclosure: I, Andreas Kupries, work for ActiveState, maintaining
ActiveTcl and TclDevKit)\&.
.PP
Do you wish to build Tcl on your own ?
The sources of all versions can be found at
.TP
Tcl
\fIhttp://core\&.tcl\&.tk/tcl/\fR
.PP
.SS TCLOO
The framework uses the \fBTclOO\fR package in its implementation\&.
This package requires Tcl 8\&.5 or higher\&.
.PP
In Tcl 8\&.6 the package is part of the core itself, without
requiring a separate installation\&.
.PP
For Tcl 8\&.5 it has to be installed separately\&.
.PP
Out of the many possibilites for getting TclOO (OS vendor,
os-independent vendor, building from sources) use whatever you are
comfortable with\&.
.PP
For myself, I am most comfortable with using
\fIActiveState's\fR [http://www\&.activestate\&.com]
ActiveTcl distribution and TEApot\&.
.PP
See the previous section (\fBTcl\fR) for disclosure and
information on how to get it\&.
.PP
Assuming that ActiveTcl got installed running the command
.CS


    teacup install TclOO

.CE
will install the package for your platform, if you have not done the
more inclusive
.CS


    teacup update

.CE
to get everything and the kitchensink\&.
.PP
For those wishing to build and install TclOO on their own, the
relevant sources can be found at \fIhttp://core\&.tcl\&.tk/tcloo\fR
together with the necessary instructions on how to build it\&.
.PP
If there are problems with building, installing, or using TclOO
and its packages please file a bug against TclOO, or the vendor of
your distribution, and not \fBcmdr\fR\&.
.SS TCLLIB
The framework requires ten packages found in Tcllib\&.
These are
.IP [1]
\fBdebug\fR
.IP [2]
\fBdebug::caller\fR
.IP [3]
\fBjson::write\fR
.IP [4]
\fBlambda\fR
.IP [5]
\fBoo::util\fR
.IP [6]
\fBstring::token::shell\fR
.IP [7]
\fBstruct::queue\fR
.IP [8]
\fBterm::ansi::code::ctrl\fR
.IP [9]
\fBtextutil::adjust\fR
.IP [10]
\fBtry\fR
.PP
.PP
Out of the many possibilites for getting Tcllib (OS vendor,
os-independent vendor, building from sources) use whatever you are
comfortable with\&.
.PP
For myself, I am most comfortable with using
\fIActiveState's\fR [http://www\&.activestate\&.com]
ActiveTcl distribution and TEApot\&.
.PP
See the previous section (\fBTcl\fR) for disclosure and
information on how to get it\&.
.PP
Assuming that ActiveTcl got installed running the commands
.CS


    teacup install debug
    teacup install debug::caller
    teacup install json::write
    teacup install lambda
    teacup install oo::util
    teacup install string::token::shell
    teacup install struct::queue
    teacup install term::ansi::code::ctrl
    teacup install textutil::adjust
    teacup install try

.CE
will install them for your platform, if you have not done the more
inclusive
.CS


    teacup update

.CE
to get everything and the kitchensink\&.
.PP
For those wishing to build and install Tcllib on their own, the
relevant sources can be found at \fIhttp://core\&.tcl\&.tk/tcllib\fR
together with the necessary instructions on how to build it\&.
.PP
If there are problems with building, installing, or using
Tcllib and its packages please file a bug against Tcllib, or the
vendor of your distribution, and not \fBcmdr\fR\&.
.SS LINENOISE
The framework uses the \fBlinenoise\fR package in its implementation\&.
This package requires Tcl 8\&.5 or higher\&.
.PP
Out of the many possibilites for getting Linenoise (OS vendor,
os-independent vendor, building from sources) use whatever you are
comfortable with\&.
.PP
For myself, I am most comfortable with using
\fIActiveState's\fR [http://www\&.activestate\&.com]
ActiveTcl distribution and TEApot\&.
.PP
See the previous section (\fBTcl\fR) for disclosure and
information on how to get it\&.
.PP
Assuming that ActiveTcl got installed running the command
.CS


    teacup install linenoise

.CE
will install the package for your platform, if you have not done the
more inclusive
.CS


    teacup update

.CE
to get everything and the kitchensink\&.
.PP
For those wishing to build and install Linenoise on their own,
the relevant sources can be found at
\fIhttp://github\&.com/andreas-kupries/tcl-linenoise\fR together with
the necessary instructions on how to build it\&.
.PP
If there are problems with building, installing, or using
linenoise please file a bug against Linenoise, or the vendor
of your distribution, and not \fBcmdr\fR\&.
.SS KETTLE
This project uses the Kettle application and package as its build system\&.
.PP
Please go to either the main repository at
\fIhttp://core\&.tcl\&.tk/akupries/kettle\fR
or the backup at
\fIhttp://chiselapp\&.com/andreas_kupries/repositories/Kettle\fR
and follow the instructions given at these sites to create a working
installation\&. They are not repeated here\&. If there are problems with
these instructions please file a bug against the Kettle project, and
not \fBCmdr\fR\&.
.PP
.SH "BUILD & INSTALLATION"
Cmdr uses the Kettle application and package to handle building
and installation\&. It is assumed to be installed and working\&. Please see
section \fBKettle\fR in \fBRequisites\fR for more information\&.
.PP
Note that all access to Kettle is mediated by the "\fIbuild\&.tcl\fR"
script, found in the top-level directory of the project\&.
.PP
For the most basic installation of Cmdr run
.CS


% /path/to/cmdr/build\&.tcl install

.CE
This command uses the \fBkettle\fR application found in the
, and the associated \fBtclsh\fR\&.
.PP
The command builds all packages and applications of Cmdr,
and then installs them so that the associated \fBtclsh\fR has access
to them\&. Any applications will become siblings of \fBtclsh\fR\&.
.PP
For more control about which version of \fBkettle\fR and/or
\fBtclsh\fR gets used run either
.CS


% /path/to/kettle /path/to/cmdr/build\&.tcl install

.CE
or even
.CS


% /path/to/tclsh /path/to/kettle /path/to/cmdr/build\&.tcl install

.CE
to specify the exact files to use\&.
.PP
On Windows it is possible to invoke the the file "\fIbuild\&.tcl\fR" with a
double-click\&. This will start a graphical interface to the system, with
buttons for all the possible actions, which includes 'install'ation\&.
.PP
On unix the same GUI is acessible by invoking "\fIbuild\&.tcl\fR" with the
arguments \fBgui\fR, i\&.e\&. as
.CS


% /path/to/cmdr/build\&.tcl gui

.CE
.PP
To get help about the methods of "\fIbuild\&.tcl\fR", and their complete
syntax, simply invoke "\fIbuild\&.tcl\fR" like
.CS


% /path/to/cmdr/build\&.tcl gui

.CE
.SH "RELATED DOCUMENTS"
.IP [1]
\fICmdr - Introduction to the project\fR
.IP [2]
\fICmdr - License\fR
.IP [3]
\fICmdr - Log of Changes\fR
.IP [4]
\fICmdr - How To Get The Sources\fR
.IP [5]
\fICmdr - The Installer's Guide\fR
.IP [6]
\fICmdr - The Developer's Guide\fR
.PP
.SH "BUGS, IDEAS, FEEDBACK"
Both the package(s) and this documentation will undoubtedly contain
bugs and other problems\&.
Please report such at
\fICmdr Tickets\fR [https:/core\&.tcl\&.tk/akupries/cmdr]\&.
.PP
Please also report any ideas you may have for enhancements of
either package(s) and/or documentation\&.
.SH KEYWORDS
arguments, command hierarchy, command line completion, command line handling, command tree, editing command line, help for command line, hierarchy of commands, interactive command shell, optional arguments, options, parameters, processing command line, tree of commands
.SH COPYRIGHT
.nf
Copyright (c) 2013-2016 Andreas Kupries
Copyright (c) 2013-2016 Documentation, Andreas Kupries

.fi