
[para] A parameter asked for its internal representation goes through
the following steps to deliver the value:

[list_begin enumerated]

[enum] If the internal representation is already known, simply deliver
it as is. In other words, the result of the following steps is cached,
and the steps are run only once.

[enum] If the internal representation has been declared as undefined
already, simply error out (again). This is still part of caching the
result generated by the following steps.

[enum] If the parameter has a string representation use the
parameter's [term {validation type}] to convert it to the proper
internal representation, and return it.

[enum] If interactive entry is possible (per the parameter's
specification) perform the interaction. This saves the entered data as
string representation which is then validated as per the previous
step. Aborting the interaction leaves the parameter as undefined
(which is thrown as error).

[enum] If a [cmd generate] callback exists use it to obtain the
internal representation, and return it.

[enum] If a [cmd default] value exists make it the internal
representation, and return it.

[para] Side note: As the parameter DSL only allows the
declaration of one of [cmd default] or [cmd generate] only one of
these steps can trigger.

[enum] If the parameter is [cmd optional] use the empty string as the
internal representation and return it.

[para] [emph Note] that this rule should never trigger as the
parameter DSL enforces that [term optional] parameters always have one
of [cmd default] or [cmd generate].

[enum] Leave the parameter is undefined and fail (throw an error).

[list_end]
