[comment {-*- tcl -*- doctools manpage}]
[include parts/definitions.inc]
[vset VERSION 1]
[manpage_begin [vset LABEL_VT_DATE] [vset MAN_SECTION] [vset VERSION]]
[include parts/module.inc]
[require try]
[require clock::iso8601]
[require cmdr::validate::common]
[require cmdr::validate::date]
[titledesc [vset TITLE_VT_DATE]]
[description]
[include parts/welcome.inc]

[para] This package provides the validation type
[cmd ::cmdr::validate::date] which accepts dates in ISO 8601 syntax.

[para] The internal representation is the epoch for the validated
input, at midnight.

[para] The type has no input completion.

[para] The details of the exported standard API can be found in
[term [vset TITLE_DEV_VT]]. The chosen default is "today".

[para] A single non-standard method is provided:

[list_begin definitions][comment {-- begin api definitions --}]
[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::date] [method 2external] [arg epoch]]

This method converts the epoch of a date to the form %Y-%m-%d and
returns the conversion result as its own.

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[list_end][comment {-- end api definitions --}]

[include parts/feedback.inc]
[manpage_end]
