[comment {-*- tcl -*- doctools manpage}]
[include parts/definitions.inc]
[vset VERSION 1.3.2]
[manpage_begin [vset LABEL_HELP] [vset MAN_SECTION] [vset VERSION]]
[include parts/module.inc]
[require cmdr::help]
[titledesc [vset TITLE_HELP]]
[description]
[include parts/welcome.inc]

This internal package implements the four standard help formats

[list_begin enumerated]
[enum] [const full],
[enum] [const short],
[enum] [const list], and
[enum] [const by-category].
[list_end]

[para] It provides a single utility command used by the other parts of
the framework to add a [syscmd help] command to any
[package cmdr::actor] requiring such.

[section API]
[list_begin definitions]
[comment {- - -- --- ----- -------- -------------}]
[call [cmd ::cmdr::help] [method auto] [arg actor]]

When invoked this command extends the [arg actor] with a [const help]
command. The result of the command is the empty string.

[para] The inserted command will accept all known format names as
options, enabling the user to choose the form of the help. By default
the format [const by-category] will be used, except if a command name
was given to [syscmd help], then the default will be [const full].

[para] An additional option accepted by [syscmd help] is
[const --width], giving the user control over the length of lines
in the help. By default help will be formatted to the width of the
terminal.

[list_begin arguments]
[arg_def [package cmdr::actor] actor]
The [package cmdr::actor] instance to be extended with [syscmd help].
[list_end]
[list_end]

[section {Format Notes}]

The format [const by-category] looks for and uses the block
[const *category-order*] for when the user wishes to override the
natural (alphabetical) order of display for the toplevel sections.

[para] This block has to be defined by the user, in the root of
the command hierarchy.

Its value has to be a dictionary mapping from the names of toplevel
sections/categories to an integer number. This is used to change
the order of displaying these sections in the generated text.

[para] Sections with higher/larger numbers are shown first, and
lower/smaller numbers move towards the end. Negative numbers are
possible.

[para] Sections not mentioned in the dictionary are assigned their
natural number. This is calculated by sorting all sections
alphabetically ([option -dict]) ascending and assigning [const 0]
to the first section, [const -10] to the next, and so on.

[para] The generated section/category [const Miscellaneous] is
given the number [const -10000] to force it to the end (bottom)
of the help text, if it was generated.

[include parts/feedback.inc]
[manpage_end]
