[comment {-*- tcl -*- doctools manpage}]
[include parts/definitions.inc]
[vset VERSION 1]
[manpage_begin [vset LABEL_VT_TIME] [vset MAN_SECTION] [vset VERSION]]
[include parts/module.inc]
[require try]
[require clock::iso8601]
[require cmdr::validate::common]
[require cmdr::validate::time]
[titledesc [vset TITLE_VT_TIME]]
[description]
[include parts/welcome.inc]

[para] This package provides the validation type
[cmd ::cmdr::validate::time] which accepts timestamps in both ISO 8601
syntax and as epoch values, i.e. positive integer seconds since the
beginning of unix time.

[para] The internal, canonical representation is the epoch for the
validated input.

[para] The type has no input completion.

[para] The details of the exported standard API can be found in
[term [vset TITLE_DEV_VT]]. The chosen default is "now".

[para] A single non-standard method is provided:

[list_begin definitions][comment {-- begin api definitions --}]
[comment {- - -- --- ----- -------- ------------- ---------------------}]
[call [cmd ::cmdr::validate::time] [method 2external] [arg epoch]]

This method converts the epoch of a time to the form
[const %Y-%m-%dT%H:%M:%S] and returns the conversion result as its own.

[comment {- - -- --- ----- -------- ------------- ---------------------}]
[list_end][comment {-- end api definitions --}]

[include parts/feedback.inc]
[manpage_end]
